% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitioners.R
\name{part_icc}
\alias{part_icc}
\title{Partitioner: distance, ICC, scaled means}
\usage{
part_icc(spearman = FALSE)
}
\arguments{
\item{spearman}{logical. Use Spearman's correlation for distance matrix?}
}
\value{
a \code{partitioner}
}
\description{
Partitioners are functions that tell the partition algorithm 1)
what to try to reduce 2) how to measure how much information is lost from
the reduction and 3) how to reduce the data. In partition, functions that
handle 1) are called directors, functions that handle 2) are called
metrics,  and functions that handle 3) are called reducers. partition has a
number of pre-specified partitioners for agglomerative data reduction.
Custom partitioners can be created with \code{\link[=as_partitioner]{as_partitioner()}}.

Pass \code{partitioner} objects to the \code{partitioner} argument of \code{\link[=partition]{partition()}}.

\code{part_icc()} uses the following direct-measure-reduce approach:
\itemize{
\item \strong{direct}: \code{direct_distance()}, Minimum Distance
\item \strong{measure}: \code{measure_icc()}, Intraclass Correlation
\item \strong{reduce}: \code{reduce_scaled_mean()}, Scaled Row Means
}
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)

# fit partition using part_icc()
partition(df, threshold = .6, partitioner = part_icc())

}
\seealso{
Other partitioners: 
\code{\link{as_partitioner}()},
\code{\link{part_kmeans}()},
\code{\link{part_minr2}()},
\code{\link{part_pc1}()},
\code{\link{part_stdmi}()},
\code{\link{replace_partitioner}()}
}
\concept{partitioners}
