% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_object_docs.R
\name{model_fit}
\alias{model_fit}
\title{Model Fit Object Information}
\description{
An object with class "model_fit" is a container for
information about a model that has been fit to the data.
}
\details{
The main elements of the object are:
\itemize{
\item \code{lvl}: A vector of factor levels when the outcome is
a factor. This is \code{NULL} when the outcome is not a factor
vector.
\item \code{spec}: A \code{model_spec} object.
\item \code{fit}: The object produced by the fitting function.
\item \code{preproc}: This contains any data-specific information
required to process new a sample point for prediction. For
example, if the underlying model function requires arguments \code{x}
and \code{y} and the user passed a formula to \code{fit}, the \code{preproc}
object would contain items such as the terms object and so on.
When no information is required, this is \code{NA}.
}

As discussed in the documentation for \code{\link{model_spec}}, the
original arguments to the specification are saved as quosures.
These are evaluated for the \code{model_fit} object prior to fitting.
If the resulting model object prints its call, any user-defined
options are shown in the call preceded by a tilde (see the
example below). This is a result of the use of quosures in the
specification.

This class and structure is the basis for how \pkg{parsnip}
stores model objects after seeing the data and applying a model.
}
\examples{

# Keep the `x` matrix if the data are not too big.
spec_obj <-
  linear_reg() \%>\%
  set_engine("lm", x = ifelse(.obs() < 500, TRUE, FALSE))
spec_obj

fit_obj <- fit(spec_obj, mpg ~ ., data = mtcars)
fit_obj

nrow(fit_obj$fit$x)
}
