% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg.R
\name{logistic_reg}
\alias{logistic_reg}
\title{Logistic regression}
\usage{
logistic_reg(
  mode = "classification",
  engine = "glm",
  penalty = NULL,
  mixture = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Possible engines are listed below. The default for this
model is \code{"glm"}.}

\item{penalty}{A non-negative number representing the total
amount of regularization (specific engines only).
For \code{keras} models, this corresponds to purely L2 regularization
(aka weight decay) while the other models can be either or a combination
of L1 and L2 (depending on the value of \code{mixture}).}

\item{mixture}{A number between zero and one (inclusive) that is the
proportion of L1 regularization (i.e. lasso) in the model. When
\code{mixture = 1}, it is a pure lasso model while \code{mixture = 0} indicates that
ridge regression is being used. (specific engines only).
For \code{LiblineaR} models, \code{mixture} must be exactly 0 or 1 only.}
}
\description{
\code{\link[=logistic_reg]{logistic_reg()}} defines a generalized linear model for binary outcomes. A
linear combination of the predictors is used to model the log odds of an
event. This function can fit classification models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("logistic_reg")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

This model fits a classification model for binary outcomes; for
multiclass outcomes, see \code{\link[=multinom_reg]{multinom_reg()}}.
}
\examples{
show_engines("logistic_reg")

logistic_reg()
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("logistic_reg")}
}
