% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_tree_party.R
\name{details_decision_tree_party}
\alias{details_decision_tree_party}
\title{Decision trees via party}
\description{
\code{\link[party:ctree]{party::ctree()}} fits a model as a set of if/then statements that creates a
tree-based structure using hypothesis testing methods.
}
\details{
For this engine, there is a single mode: censored regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{tree_depth}: Tree Depth (type: integer, default: see below)
\item \code{min_n}: Minimal Node Size (type: integer, default: 20L)
}

The \code{tree_depth} parameter defaults to \code{0} which means no restrictions
are applied to tree depth.

An engine-specific parameter for this model is:
\itemize{
\item \code{mtry}: the number of predictors, selected at random, that are
evaluated for splitting. The default is to use all predictors.
}
}

\subsection{Translation from parsnip to the original package (censored regression)}{

The \strong{censored} extension package is required to fit this model.\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

decision_tree(tree_depth = integer(1), min_n = integer(1)) \%>\% 
  set_engine("party") \%>\% 
  set_mode("censored regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Decision Tree Model Specification (censored regression)
## 
## Main Arguments:
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: party 
## 
## Model fit template:
## censored::cond_inference_surv_ctree(formula = missing_arg(), 
##     data = missing_arg(), maxdepth = integer(1), minsplit = min_rows(0L, 
##         data))
}

\code{censored::cond_inference_surv_ctree()} is a wrapper around
\code{\link[party:ctree]{party::ctree()}} (and other functions) that makes it
easier to run this model.
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{References}{
\itemize{
\item Hothorn T, Hornik K, Zeileis A. 2006. Unbiased Recursive
Partitioning: A Conditional Inference Framework. \emph{Journal of
Computational and Graphical Statistics}, 15(3), 651–674.
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
