% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_reg.R
\name{surv_reg}
\alias{surv_reg}
\alias{update.surv_reg}
\title{General Interface for Parametric Survival Models}
\usage{
surv_reg(mode = "regression", dist = NULL)

\method{update}{surv_reg}(object, parameters = NULL, dist = NULL,
  fresh = FALSE, ...)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{dist}{A character string for the outcome distribution. "weibull" is
the default.}

\item{object}{A survival regression model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\description{
\code{surv_reg()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
R. The main argument for the
model is:
\itemize{
\item \code{dist}: The probability distribution of the outcome.
}
This argument is converted to its specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to its default
here (\code{NULL}), the value is taken from the underlying model
functions.

If parameters need to be modified, this function can be used
in lieu of recreating the object from scratch.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{surv_reg()},the
mode will always be "regression".

Since survival models typically involve censoring (and require the use of
\code{\link[survival:Surv]{survival::Surv()}} objects), the \code{\link[=fit]{fit()}} function will require that the
survival model be specified via the formula interface.

Also, for the \code{flexsurv::flexsurvfit} engine, the typical
\code{strata} function cannot be used. To achieve the same effect,
the extra parameter roles can be used (as described above).

For \code{surv_reg()}, the mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"flexsurv"}, \code{"survival"} (the default)
}
}
\section{Engine Details}{


Engines may have pre-set default arguments when executing the
model fit call. For this type of
model, the template of the fit calls are:

\pkg{flexsurv}

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::surv_reg(), "flexsurv")}

\pkg{survival}

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::surv_reg(), "survival")}

Note that \code{model = TRUE} is needed to produce quantile
predictions when there is a stratification variable and can be
overridden in other cases.
}

\examples{
surv_reg()
# Parameters can be represented by a placeholder:
surv_reg(dist = varying())

model <- surv_reg(dist = "weibull")
model
update(model, dist = "lnorm")
}
\references{
Jackson, C. (2016). \code{flexsurv}: A Platform for Parametric Survival
Modeling in R. \emph{Journal of Statistical Software}, 70(8), 1 - 33.
}
\seealso{
[\code{\link[=fit]{fit()}}, \code{\link[survival:Surv]{survival::Surv()}}
}
