#include "../inst/include/parser.h"

#ifdef Win32
static char * fixmode(const char *mode){
    /* Rconnection can have a mode of 4 chars plus a null; we might
     * add one char */
    static char fixedmode[6];
    fixedmode[4] = '\0';
    strncpy(fixedmode, mode, 4);
    if (!strpbrk(fixedmode, "bt")) {
		strcat(fixedmode, "t");
    }
    return fixedmode;
}

#else
#define fixmode(mode) (mode)
#endif

FILE * _fopen(const char *filename, const char *mode){
    return(filename ? fopen(filename, fixmode(mode)) : NULL );
}


int _fgetc(FILE *fp) {
	
#ifdef Win32
    int c;
    static int nexteof=0;
    if (nexteof) {
       nexteof = 0;
       return R_EOF;
    }
    c = fgetc(fp);
    if (c==EOF) {
       nexteof = 1;
       return '\n';
    }
#else
    int c = fgetc(fp);
#endif
    /* get rid of  CR in CRLF line termination */
    if (c == '\r') {
		c = fgetc(fp);
		/* retain CR's with no following linefeed */
		if (c != '\n') {
		    ungetc(c,fp);
		    return('\r');
		}
    }
#ifdef Win32
    return c;
#else
    return feof(fp) ? R_EOF : c;
#endif
}

