% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_AD.R
\name{compute_AD}
\alias{compute_AD}
\title{Anderson-Darling goodness of fit test statistic}
\usage{
compute_AD(data, dist, time = "time", censor = "censor")
}
\arguments{
\item{data}{A dataframe containing a time column and a censor column.}

\item{dist}{A string name for a distribution that has a corresponding density function and a distribution function.
Examples include "norm", "lnorm", "exp", "weibull", "logis", "llogis", "gompertz", etc.}

\item{time}{The string name of the time column of the dataframe. Defaults to "time".}

\item{censor}{The string name of the censor column of the dataframe. Defaults to "censor". 
The censor column must be a numeric indicator variable where complete times correspond 
to a value of 1 and incomplete times correspond to 0.}
}
\description{
Computes Anderson-Darling goodness of fit test statistic given that the data follows 
a specified parametric distribution.
}
\examples{
data("rearrest")
compute_AD(rearrest, "lnorm", time = "months")
compute_AD(rearrest, "weibull", time = "months")
}
