% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters_default.R,
%   R/model_parameters_mixed.R
\name{model_parameters.mixor}
\alias{model_parameters.mixor}
\alias{model_parameters.merMod}
\alias{model_parameters.glmmTMB}
\title{Mixed Model Parameters}
\usage{
\method{model_parameters}{mixor}(
  model,
  ci = 0.95,
  effects = c("all", "fixed", "random"),
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  ...
)

\method{model_parameters}{merMod}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  df_method = "wald",
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  ...
)

\method{model_parameters}{glmmTMB}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  component = c("all", "conditional", "zi", "zero_inflated"),
  standardize = NULL,
  exponentiate = FALSE,
  ...
)
}
\arguments{
\item{model}{A mixed model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{effects}{Should parameters for fixed effects, random effects or both be returned? Only applies to mixed models. May be abbreviated.}

\item{bootstrap}{Should estimates be based on bootstrapped model? If \code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also \code{\link[=parameters_bootstrap]{parameters_bootstrap()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the case of bootstrapped frequentist models.}

\item{standardize}{The method used for standardizing the parameters. Can be \code{"refit"}, \code{"posthoc"}, \code{"smart"}, \code{"basic"} or \code{NULL} (default) for no standardization. See 'Details' in \code{\link[effectsize]{standardize_parameters}}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the the coefficients (and related confidence intervals). This is typical for, say, logistic regressions, or more generally speaking: for models with log or logit link.}

\item{...}{Arguments passed to or from other methods.}

\item{df_method}{Method for computing degrees of freedom for p values, standard errors and confidence intervals (CI). May be \code{"wald"} (default, see \code{\link{degrees_of_freedom}}), \code{"ml1"} (see \code{\link{dof_ml1}}), \code{"satterthwaite"} (see \code{\link{dof_satterthwaite}}) or \code{"kenward"} (see \code{\link{dof_kenward}}).}

\item{component}{Model component for which parameters should be shown. May be one of \code{"conditional"}, \code{"precision"} (\pkg{betareg}), \code{"scale"} (\pkg{ordinal}), \code{"extra"} (\pkg{glmx}) or \code{"all"}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters of (linear) mixed models.
}
\examples{
library(parameters)
library(lme4)
library(glmmTMB)

model <- lmer(mpg ~ wt + (1 | gear), data = mtcars)
model_parameters(model)

model <- glmmTMB(
  count ~ spp + mined + (1 | site),
  ziformula = ~mined,
  family = poisson(),
  data = Salamanders
)
model_parameters(model)
\donttest{
model <- lme4::lmer(mpg ~ wt + (1 | gear), data = mtcars)
model_parameters(model, bootstrap = TRUE, iterations = 50)
}

}
\seealso{
\code{\link[=standardize_names]{standardize_names()}} to rename
  columns into a consistent, standardized naming scheme.
}
