% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_analysis.R
\name{factor_analysis}
\alias{factor_analysis}
\title{Factor Analysis (FA)}
\usage{
factor_analysis(x, n = "auto", rotation = "none", sort = FALSE,
  threshold = NULL, standardize = TRUE, ...)
}
\arguments{
\item{x}{A dataframe or a statistical model.}

\item{n}{Number of components to extract. If \code{n = "all"} =, then \code{n} is set as the number of variables minus 1 (\code{ncol(x)-1}). If \code{n = "auto"} (default) or \code{n = NULL}, the number of components is selected through \code{\link{n_factors}}. In \code{\link{parameters_reduction}}, can also be \code{"max"}, in which case it will select all the components that are maximally pseudo-loaded (i.e., correlated) by at least one variable.}

\item{rotation}{If not "none", the PCA will be computed using the \pkg{psych} package. Possible options include \code{"varimax"}, \code{"quartimax"}, \code{"promax"}, \code{"oblimin"}, \code{"simplimax"}, and \code{"cluster"}. See \code{\link[psych]{fa}} for details.}

\item{sort}{Sort the loadings.}

\item{threshold}{A value between 0 and 1 indicates which (absolute) values from the loadings should be removed. An integer higher than 1 indicates the n strongest loadings to retain. Can also be "max", in which case it will only display the maximum loading per variable (the most simple structure).}

\item{standardize}{A logical value indicating whether the variables should be standardized (centred and scaled) to have unit variance before the analysis takes place (in general, such scaling is advisable).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data.frame of loadings.
}
\description{
This function performs a Factor Analysis (FA).
}
\details{
\subsection{Complexity}{
   Complexity represents the number of latent components needed to account
   for the observed variables. Whereas a perfect simple structure solution
   has a complexity of 1 in that each item would only load on one factor,
   a solution with evenly distributed items has a complexity greater than 1
   (\cite{Hofman, 1978; Pettersson and Turkheimer, 2010}) .
 }
 \subsection{FA or PCA?}{
 There is a simplified rule of thumb that may help do decide whether to run
 a principal component analysis or a factor analysis:
 \itemize{
   \item Run principal component analysis if you assume or wish to test a theoretical model of latent factors causing observed variables.
   \item Run factor analysis If you want to simply reduce your correlated observed variables to a smaller set of important independent composite variables.
 }
 (Source: \href{https://stats.stackexchange.com/q/1576/54740}{CrossValidated})
 }
}
\note{
There is a \code{summary()}-method that prints the Eigenvalues and (explained) variance for each extracted component.
}
\examples{
library(parameters)

factor_analysis(mtcars[, 1:7], n = "all", threshold = 0.2)
factor_analysis(mtcars[, 1:7], n = 2, rotation = "oblimin", threshold = "max", sort = TRUE)
factor_analysis(mtcars[, 1:7], n = 2, threshold = 2, sort = TRUE)

FA <- factor_analysis(mtcars[, 1:5], n = 2)
summary(FA)
predict(FA)
\donttest{
# Automated number of components
factor_analysis(mtcars[, 1:4], n = "auto")
}

}
\references{
\itemize{
  \item Hofmann, R. (1978). Complexity and simplicity as objective indices descriptive of factor solutions. Multivariate Behavioral Research, 13:2, 247-250, \doi{10.1207/s15327906mbr1302_9}
  \item Pettersson, E., & Turkheimer, E. (2010). Item selection, evaluation, and simple structure in personality data. Journal of research in personality, 44(4), 407-420, \doi{10.1016/j.jrp.2010.03.002}
}
}
