% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_parameters.R
\name{random_parameters}
\alias{random_parameters}
\title{Summary information from random effects}
\usage{
random_parameters(model, component = "conditional")
}
\arguments{
\item{model}{A mixed effects model (including \code{stanreg} models).}

\item{component}{Should all parameters, parameters for the conditional model,
for the zero-inflation part of the model, or the dispersion model be returned?
Applies to models with zero-inflation and/or dispersion component. \code{component}
may be one of \code{"conditional"}, \code{"zi"}, \code{"zero-inflated"}, \code{"dispersion"} or
\code{"all"} (default). May be abbreviated.}
}
\value{
A data frame with random effects statistics for the variance components,
including number of levels per random effect group, as well as complete
observations in the model.
}
\description{
This function extracts the different variance components of a
mixed model and returns the result as a data frame.
}
\details{
The variance components are obtained from \code{\link[insight:get_variance]{insight::get_variance()}}
and are denoted as following:

\strong{Within-group (or residual) variance}

The residual variance, \ifelse{html}{\out{&sigma;<sup>2</sup><sub>&epsilon;</sub>}}{\eqn{\sigma^2_\epsilon}},
is the sum of the distribution-specific variance and the variance due to additive dispersion.
It indicates the \emph{within-group variance}.

\strong{Between-group random intercept variance}

The random intercept variance, or \emph{between-group} variance
for the intercept (\ifelse{html}{\out{&tau;<sub>00</sub>}}{\eqn{\tau_{00}}}),
is obtained from \code{VarCorr()}. It indicates how much groups
or subjects differ from each other.

\strong{Between-group random slope variance}

The random slope variance, or \emph{between-group} variance
for the slopes (\ifelse{html}{\out{&tau;<sub>11</sub>}}{\eqn{\tau_{11}}})
is obtained from \code{VarCorr()}. This measure is only available
for mixed models with random slopes. It indicates how much groups
or subjects differ from each other according to their slopes.

\strong{Random slope-intercept correlation}

The random slope-intercept correlation
(\ifelse{html}{\out{&rho;<sub>01</sub>}}{\eqn{\rho_{01}}})
is obtained from \code{VarCorr()}. This measure is only available
for mixed models with random intercepts and slopes.

\strong{Note:} For the within-group and between-group variance, variance
and standard deviations (which are simply the square root of the variance)
are shown.
}
\examples{
if (require("lme4")) {
  data(sleepstudy)
  model <- lmer(Reaction ~ Days + (1 + Days | Subject), data = sleepstudy)
  random_parameters(model)
}
}
