% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_parameters.R
\name{compare_parameters}
\alias{compare_parameters}
\alias{compare_models}
\title{Compare model parameters of multiple models}
\usage{
compare_parameters(
  ...,
  ci = 0.95,
  effects = "fixed",
  component = "conditional",
  standardize = NULL,
  exponentiate = FALSE,
  df_method = "wald",
  p_adjust = NULL,
  style = NULL,
  column_names = NULL,
  groups = NULL,
  verbose = TRUE
)

compare_models(
  ...,
  ci = 0.95,
  effects = "fixed",
  component = "conditional",
  standardize = NULL,
  exponentiate = FALSE,
  df_method = "wald",
  p_adjust = NULL,
  style = NULL,
  column_names = NULL,
  groups = NULL,
  verbose = TRUE
)
}
\arguments{
\item{...}{One or more regression model objects, or objects returned by
\code{model_parameters()}. Regression models may be of different model
types.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{effects}{Should parameters for fixed effects (\code{"fixed"}), random
effects (\code{"random"}), or both (\code{"all"}) be returned? Only applies
to mixed models. May be abbreviated.}

\item{component}{Model component for which parameters should be shown. See
documentation for related model class in \code{\link{model_parameters}}.}

\item{standardize}{The method used for standardizing the parameters. Can be
\code{"refit"}, \code{"posthoc"}, \code{"smart"}, \code{"basic"},
\code{"pseudo"} or \code{NULL} (default) for no standardization. See
'Details' in \code{\link[effectsize]{standardize_parameters}}.
\strong{Important:} Categorical predictors (i.e. factors) are \emph{never}
standardized by default, which may be a different behaviour compared to
other R packages or other software packages (like SPSS). If standardizing
categorical predictors is desired, either use \code{standardize="basic"}
to mimic behaviour of SPSS or packages such as \pkg{lm.beta}, or standardize
the data with \code{effectsize::standardize(force=TRUE)} before fitting
the model. Robust estimation (i.e. \code{robust=TRUE}) of standardized
parameters only works when \code{standardize="refit"}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log
or logit links. \strong{Note:} Delta-method standard errors are also
computed (by multiplying the standard errors by the transformed
coefficients). This is to mimic behaviour of other software packages, such
as Stata, but these standard errors poorly estimate uncertainty for the
transformed coefficient. The transformed confidence interval more clearly
captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients
from non-Gaussian families.}

\item{df_method}{Method for computing degrees of freedom for p values,
standard errors and confidence intervals (CI). See documentation for
related model class in \code{\link{model_parameters}}.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats]{p.adjust}} for details. Further
possible adjustment methods are \code{"tukey"}, \code{"scheffe"},
\code{"sidak"} and \code{"none"} to explicitly disable adjustment for
\code{emmGrid} objects (from \pkg{emmeans}).}

\item{style}{String, indicating which style of output is requested. Following
templates are possible:
\itemize{
  \item \code{"ci"}: Estimate and confidence intervals, no asterisks for p-values.
  \item \code{"se"}: Estimate and standard errors, no asterisks for p-values.
  \item \code{"ci_p"}: Estimate, confidence intervals and asterisks for p-values.
  \item \code{"se_p"}: Estimate, standard errors and asterisks for p-values.
  \item \code{"ci_p2"}: Estimate, confidence intervals and numeric p-values, in two columns.
  \item \code{"se_p2"}: Estimate, standard errors and numeric p-values, in two columns.
}}

\item{column_names}{Character vector with strings that should be used as
column headers. Must be of same length as number of models in \code{...}.}

\item{groups}{Named list, can be used to group parameters in the printed output.
List elements may either be character vectors that match the name of those
parameters that belong to one group, or list elements can be row numbers
of those parameter rows that should belong to one group. The names of the
list elements will be used as group names, which will be inserted as "header
row". A possible use case might be to emphasize focal predictors and control
variables, see 'Examples'. Parameters will be re-ordered according to the
order used in \code{groups}, while all non-matching parameters will be added
to the end.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Compute and extract model parameters of multiple regression models.
  See \code{\link{model_parameters}} for further details.
}
\note{
This function is in an early stage and does not yet cope with more
  complex models, and probably does not yet properly render all model
  components.
}
\examples{
data(iris)
lm1 <- lm(Sepal.Length ~ Species, data = iris)
lm2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
lm3 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)
compare_parameters(lm1, lm2, lm3)

data(mtcars)
m1 <- lm(mpg ~ wt, data = mtcars)
m2 <- glm(vs ~ wt + cyl, data = mtcars, family = "binomial")
compare_parameters(m1, m2)

\dontrun{
# exponentiate coefficients, but not for lm
compare_parameters(m1, m2, exponentiate = "nongaussian")

# change column names
compare_parameters(m1, m2, column_names = c("linear model", "logistic reg."))
}
}
