% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd.R
\name{cnd}
\alias{cnd}
\title{Create a ParameterSet Condition}
\usage{
cnd(type, value = NULL, id = NULL)
}
\arguments{
\item{type}{(\code{character(1)}) \cr
The condition \code{type} determines the type of dependency to create, options
are given in details.}

\item{value}{(\code{ANY}) \cr
If \code{id} is \code{NULL} then \code{value} should be a value in the support of the
parameter that the condition is testing, that will be passed to the condition
determined by \code{type}.}

\item{id}{(\code{character(1)}) \cr
If \code{value} is \code{NULL} then \code{id} should be the same as the id that the
condition is testing, and the condition then takes the currently set value
of the id in its argument.}
}
\description{
Function to create a condition for \link{ParameterSet} dependencies
for use in the \verb{$deps} public method.
}
\details{
This function should never be used outside of creating a condition for
a dependency in a \link{ParameterSet}. Currently the following conditions are
supported based on the \code{type} argument, we refer to the parameter depended on
as in the independent parameter, and the other as the dependent:
\itemize{
\item \code{"eq"} - If \code{value} is not \code{NULL} then checks if the independent parameter
equals \code{value}, otherwise checks if the independent and dependent parameter
are equal.
\item \code{"neq"} - If \code{value} is not \code{NULL} then checks if the independent parameter
does not equal \code{value}, otherwise checks if the independent and dependent
parameter are not equal.
\item \code{"gt"/"lt"} - If \code{value} is not \code{NULL} then checks if the independent
parameter is greater/less than \code{value}, otherwise checks if the independent
parameter is greater/less than the dependent parameter.
\item \code{"geq"/"leq"} - If \code{value} is not \code{NULL} then checks if the independent
parameter is greater/less than or equal to \code{value}, otherwise checks if the
independent parameter is greater/less than or equal to the dependent
parameter.
\item \code{"any"} - If \code{value} is not \code{NULL} then checks if the independent parameter
equals any of \code{value}, otherwise checks if the independent parameter equals
any of dependent parameter.
\item \code{"nany"} - If \code{value} is not \code{NULL} then checks if the independent
parameter does not equal any of \code{value}, otherwise checks if the independent
parameter does not equal any of dependent parameter.
\item \code{"len"} - If \code{value} is not \code{NULL} then checks if the length of the
independent parameter equals \code{value}, otherwise checks if the independent
and dependent parameter are the same length.
}
}
