% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment_GH.R
\name{moment_GH}
\alias{moment_GH}
\title{Moments of Tukey \eqn{g}-&-\eqn{h} Distribution}
\usage{
moment_GH(A = 0, B = 1, g = 0, h = 0)
}
\arguments{
\item{A, B, g, h}{\link[base]{numeric} scalars or \link[base]{vector}s,
location, scale, skewness and elongation parameters of
Tukey \eqn{g}-&-\eqn{h} distribution}
}
\value{
Function \link{moment_GH} returns a \linkS4class{moment} object.
}
\description{
Moments of Tukey \eqn{g}-&-\eqn{h} distribution.
}
\examples{
A = 3; B = 1.5; g = .7; h = .01
moment_GH(A = A, B = B, g = 0, h = h)
moment_GH(A = A, B = B, g = g, h = 0)
moment_GH(A = A, B = B, g = g, h = h)

}
\references{
Raw moments of Tukey \eqn{g}-&-\eqn{h} distribution: \doi{10.1002/9781118150702.ch11}
}
