% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamFct.R
\name{ParamFct}
\alias{ParamFct}
\title{Factor Parameter}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Param}.
}
\description{
A \link{Param} to describe categorical (factor) parameters.
}
\section{Construction}{
\preformatted{ParamFct$new(id, levels, special_vals = list(), default = NO_DEF, tags = character())
}

Arguments of \link{Param}, and additionally:
\itemize{
\item \code{levels} :: \code{character()}\cr
Set of allowed levels.
}
}

\section{Fields}{

Fields of \link{Param}, and additionally:
\itemize{
\item \code{lower} :: \code{numeric(1)}\cr
Lower bound.
Always \code{NA} for this parameter.
\item \code{upper} :: \code{numeric(1)}\cr
Upper bound.
Always \code{NA} for this parameter.
\item \code{levels} :: \code{character()}\cr
Allowed levels.
\item \code{nlevels} :: \code{Inf} \cr
Number of categorical levels.
\item \code{is_bounded} :: \code{TRUE}\cr
Are the bounds finite?
Always \code{TRUE} for this parameter.
}
}

\section{Methods}{

See \link{Param}.
}

\examples{
ParamFct$new("f", levels = letters[1:3])
}
\seealso{
Other Params: 
\code{\link{ParamDbl}},
\code{\link{ParamInt}},
\code{\link{ParamLgl}},
\code{\link{ParamUty}},
\code{\link{Param}}
}
\concept{Params}
