% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvarhk.R
\name{pvarhk}
\alias{pvarhk}
\title{Hahn Kuehrsteiner Estimator for PVAR Model}
\usage{
pvarhk(
  dependent_vars,
  exog_vars,
  transformation = c("demean"),
  data,
  panel_identifier = c(1, 2)
)
}
\arguments{
\item{dependent_vars}{Dependent variables}

\item{exog_vars}{Exogenous variables}

\item{transformation}{Demeaning \code{"demean"}}

\item{data}{Data set}

\item{panel_identifier}{Vector of panel identifiers}
}
\description{
This function estimates a stationary PVAR with fixed effects.
}
\examples{
data(Dahlberg)
ex1_hk <-
pvarhk(dependent_vars = c("expenditures", "revenues", "grants"),
        transformation = "demean",
        data = Dahlberg,
        panel_identifier= c("id", "year"))

summary(ex1_hk)
                                   
}
\references{
Hahn J., Kuehrsteiner G. (2002) Asymptotically Unbiased Inference for a Dynamic Panel Model with Fixed Effects When Both n and T Are Large, \emph{Econometrica}, \bold{70}(4), 1639--1657
}
