% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{formula.wbm}
\alias{formula.wbm}
\title{Retrieve model formulas from \code{wbm} objects}
\usage{
\method{formula}{wbm}(x, raw = FALSE, ...)
}
\arguments{
\item{x}{\R object, for \code{DF2formula()} a \code{\link{data.frame}}.}

\item{raw}{Return the formula used in the call to \code{lmerMod}/\code{glmerMod}?
Default is FALSE.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This S3 method allows you to retrieve the formula used to
fit \code{wbm} objects.
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
model <- wbm(lwage ~ lag(union) + wks, data = wages)
# Returns the original model formula rather than the one sent to lme4
formula(model)
}
