% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotters.R
\name{line_plot}
\alias{line_plot}
\title{Plot trends in longitudinal variables}
\usage{
line_plot(
  data,
  var,
  id = NULL,
  wave = NULL,
  overlay = TRUE,
  show.points = TRUE,
  subset.ids = FALSE,
  n.random.subset = 9,
  add.mean = FALSE,
  mean.function = "lm",
  line.size = 1,
  alpha = if (overlay) 0.5 else 1
)
}
\arguments{
\item{data}{Either a \code{panel_data} frame or another data frame.}

\item{var}{The unquoted name of the variable of interest.}

\item{id}{If \code{data} is not a \code{panel_data} object, then the id variable.}

\item{wave}{If \code{data} is not a \code{panel_data} object, then the wave variable.}

\item{overlay}{Should the lines be plotted in the same panel or each in
their own facet/panel? Default is TRUE, meaning they are plotted in the
same panel.}

\item{show.points}{Plot a point at each wave? Default is TRUE.}

\item{subset.ids}{Plot only a subset of the entities' lines? Default is NULL,
meaning plot all ids. If TRUE, a random subset (the number defined by
\code{n.random.subset}) are plotted. You may also supply a vector of ids to
choose them yourself.}

\item{n.random.subset}{How many entities to randomly sample when \code{subset.ids}
is TRUE.}

\item{add.mean}{Add a line representing the mean trend? Default is FALSE.
Cannot be combined with \code{overlay}.}

\item{mean.function}{The mean function to supply to \code{geom_smooth} when
\code{add.mean} is TRUE. Default is \code{"lm"}, but another option of interest is
\code{"loess"}.}

\item{line.size}{The thickness of the plotted lines. Default: 0.5}

\item{alpha}{The transparency for the lines and points. When
\code{overlay = TRUE}, it is set to 0.5, otherwise 1, which means
non-transparent.}
}
\value{
The \code{ggplot} object.
}
\description{
\code{line_plot} allows for flexible visualization of repeated
measures variables from \code{panel_data} frames.
}
\examples{

data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
line_plot(wages, lwage, add.mean = TRUE, subset.ids = TRUE, overlay = FALSE)

}
