% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-activate.R
\name{pandoc_activate}
\alias{pandoc_activate}
\title{Activate a specific Pandoc version to be used}
\usage{
pandoc_activate(
  version = "latest",
  rmarkdown = getOption("pandoc.activate_rmarkdown", TRUE),
  quiet = FALSE
)
}
\arguments{
\item{version}{This can be either:
\itemize{
\item \code{"latest"} for the latest release
\item A version number (e.g \code{"2.11.4"}) for a specific version
\item \code{"nightly"} for the last pandoc development built daily
}}

\item{rmarkdown}{if \code{TRUE} (the default) and \strong{rmarkdown} is available, this
will also set the pandoc version as the default one to use with
\strong{rmarkdown} by calling \code{\link[rmarkdown:find_pandoc]{rmarkdown::find_pandoc()}}. Default behavior can
be changed globally by setting option \code{pandoc.activate_rmarkdown}.}

\item{quiet}{\code{TRUE} to suppress messages.}
}
\value{
invisibly, the previous active version.
}
\description{
This function will set the specified version as the default version for the
session. By default, the default active version in the most recent one among
the installed version (nightly version excluded.)
}
\section{Special behavior in an interactive session}{
If the \code{version} to activate is not yet installed, the user will be prompted
to choose to install the version.
}

\section{Default active version}{
When the package is loaded, an active version is set to the first Pandoc
binary found between:
\itemize{
\item the latest Pandoc version installed with this package (e.g \code{"2.14.2"})
\item the version shipped with RStudio IDE. (\code{version = "rstudio"})
\item a version available in PATH (\code{version = "system"})
}
}

\examples{
\dontshow{if (pandoc::pandoc_is_installed("2.18")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# activate version 2.18, including for use with rmarkdown package
pandoc_activate("2.18")

# activate only for this package functions and not rmarkdown
pandoc_activate("2.18", rmarkdown = FALSE)
\dontshow{\}) # examplesIf}
}
