\name{day2l}
\alias{day2l}
\alias{l2day}
\alias{date_of_perihelion}
 
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Converts calendar day into true solar longitude and vice-versa}
\description{Converts calendar day into true solar longitude for a given astronomical configuration and vice-versa}

\usage{
day2l  (orbit,day) 
l2day  (orbit,l)
date_of_perihelion (orbit)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{orbit}{Output from a solution, such as \code{ber78}, \code{ber90} or \code{la04}}
  \item{l}{true solar longitude, in radiants}
  \item{day}{calendar day, in a 360-d year}
}
\details{ 
The 360-d calendar is a conventional calendar, for which
day 80 is the day of NH spring equinoxe. The tropic year, which 
in reality is 365.24219876 * 86400 seconds was the practical reference
to define the Gregorian Calendar since this is the time needed to 
go through all the seasons. More discussion of calendars and conversions
in Berger et al. (2010) appendix D.

The \code{day2l} and \code{l2day} is based on algoritms
given in Berger (1978), but which can be traced back to 
 expansions of the mean and true anomaly by Brouwer and Clemente (1961), 
pp. 65 and 77 (see code for further details). 
}

\value{
  day of year (360-d cal.) or true solar longitude (in radiants). 
  }

\references{
Brouwer D. and G. M. Clemence, (1961),  Methods of celestial mechanics, Academic Press, New York.

 Berger, (1978) Long-term variations of daily insolation and Quaternary climatic changes,  J. Atmos. Sci., 35, 2362-2367  1978, doi:10.1175/1520-0469(1978)035<2362:LTVODI>2.0.CO;2

 Berger, A. Loutre, M.F. and Yin Q. (2010),  Total irradiation during any time interval of the year using elliptic integrals,  Quaternary Science Reviews, 29, 1968 - 1982, doi:10.1016/j.quascirev.2010.05.007
}
  
\author{Michel Crucifix, U. catholique de Louvain, Belgium.}

\examples{
## date of perihelion throughout today
orbit=c(eps=0.409214, ecc=0.01672393, varpi=4.92251)
date_of_perihelion(orbit)
## date of winter solstice)
l2day(orbit, 270*pi/180.)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.

