% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divCurveFossilRecordSim.R
\name{divCurveFossilRecordSim}
\alias{divCurveFossilRecordSim}
\title{Diversity-Curve Plotting for Simulations of Diversification and Sampling In the Fossil Record}
\usage{
divCurveFossilRecordSim(fossilRecord, merge.cryptic = TRUE,
  plotLegend = TRUE, legendPosition = "topleft", curveColors = c("black",
  "red"), curveLineTypes = c(1, 2))
}
\arguments{
\item{fossilRecord}{A list object output by \code{simFossilRecord}, often composed
of multiple elements, each of which is data for 'one taxon', with the first
element being a distinctive six-element vector composed of numbers, corresponding
to the six variable tables by \code{fossilRecord2fossilTaxa} after simulating with
\code{simFossilRecord} (originally produced by deprecated function \code{simFossilTaxa}).}

\item{merge.cryptic}{If \code{TRUE}, cryptic taxon-units (i.e.
those in the same cryptic complex) will be merged into single taxa for the
sake of being counted in the diversity curves presented by this function.}

\item{plotLegend}{A logical. Should a legend be plotted? Only applies if sampling
processes were modeled.}

\item{legendPosition}{Where should the legend be plotted? See help for \code{legend}
for details. Only applies if sampling processes were modeled.}

\item{curveColors}{A vector of length two indicating what colors the original and sampled
diversity curves should be displayed in. Only applies if sampling processes were modeled.}

\item{curveLineTypes}{A vector of length two indicating what colors the original and sampled
diversity curves should be displayed in. Only applies if sampling processes were modeled.}
}
\value{
This function returns nothing: it just creates a plot.
}
\description{
An extremely simple plotting function, which plots the original taxonomic diversity
versus the sampled taxonomic diversity, for use with output from the function \code{simFossilRecord}.
If sampling processes were not included in the model, then it plots simply the
single diversity curve.
}
\details{
This function is essentially a wrapper for \code{paleotree} function \code{multiDiv}.
}
\examples{

set.seed(44)
record <- simFossilRecord(p=0.1, q=0.1, r=0.1, nruns=1,
	nTotalTaxa=c(20,30) ,nExtant=0, plot=FALSE)

# now let's plot it
divCurveFossilRecordSim(record)

}
\author{
David W. Bapst
}
\seealso{
\code{\link{simFossilRecord}}
}

