% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_temporal_functions.R
\name{pbdb_temporal_resolution}
\alias{pbdb_temporal_resolution}
\title{Temporal resolution of fossil data}
\usage{
pbdb_temporal_resolution(data, do_plot = TRUE)
}
\arguments{
\item{data}{Data frame from a query to PaleobioDB as returned by
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}}.}

\item{do_plot}{Logical. If \code{TRUE}, the function creates a
frequency plot of the data.}
}
\value{
A list with a summary of the temporal resolution of the
data (min, max, 1st and 3rd quartiles, median and mean), and the
temporal resolution of each fossil record (Ma).
}
\description{
Shows the temporal resolution of the fossil data.
}
\examples{
\dontrun{
  data <- pbdb_occurrences(taxon_name = "Canidae", interval = "Quaternary")
  pbdb_temporal_resolution(data)
}
}
