% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{sim.sgs}
\alias{sim.sgs}
\title{Simulate protracted punctuation}
\usage{
sim.sgs(
  ns = c(20, 20, 20),
  theta = 0,
  omega = 1,
  ms = 1,
  vs = 0.1,
  nn = rep(30, sum(ns)),
  tt = 0:(sum(ns) - 1),
  vp = 1
)
}
\arguments{
\item{ns}{vector with the number of samples in each segment}

\item{theta}{trait mean for initial stasis segment}

\item{omega}{trait variance for stasis segments}

\item{ms}{step mean during random walk segment}

\item{vs}{step variance during random walk segment}

\item{nn}{vector of sample sizes for each population}

\item{tt}{vector of times (ages) for each population}

\item{vp}{phenotypic trait variance for each population}
}
\value{
a \code{paleoTS} object
}
\description{
This function simulates a punctuated change that is is protracted enough that
it is captured by multiple transitional populations.  Trait evolution starts in stasis,
shifts to a general random walk, and then shifts back into stasis.
}
\details{
Trait evolution proceeds in three segments: Stasis, General random walk, stasis (sgs).
The initial stasis segment has a mean of \code{theta} and variance \code{omega} before
shifting in the second segment to a general random walk with parameters \code{ms} and
\code{vs}. Finally, the third segment is a return to stasis, centered around the trait value
of the last population of the random walk.
}
\examples{
x <- sim.sgs()  # default values OK
plot(x)
}
