% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{abdistr_}
\alias{abdistr_}
\title{Count number of entries in occurrence or collection data.frame for specific points in geological time}
\usage{
abdistr_(
  x,
  table = NULL,
  ab.val = table$abund_value,
  smooth = 0,
  max = table$eag,
  min = table$lag,
  w = rep(1, length(x))
)
}
\arguments{
\item{x}{A numeric vector giving the times (in ma) at which to determine the number of overlapping records.}

\item{table}{An occurrence or collection dataset}

\item{ab.val}{Abundance value to be used. Default is table$abund_value. If NULL (e.g. because this column doesn’t exist) or NA, each occurrence is treated as representing one specimen}

\item{smooth}{The smoothing margin, in units of ma. Corresponds to the plusminus parameter of rmeana(). Defaults to 0, i.e. no smoothing (beyond the resolution determined by the resolution of x)}

\item{max}{Vector or column containing maximum age of each occurrence or collection}

\item{min}{Vector or column containing minimum age of each occurrence or collection}

\item{w}{A Vector of weights. Must be of same length as x}
}
\value{
A numeric vector of the same length as x, giving the estimated number of occurrence records (if ab.val==FALSE) or specimens (if ab.val==TRUE), or the estimated number of collections (if collection data are used instead of occurrences) overlapping each temporal value given in x
}
\description{
Count number of entries in occurrence or collection data.frame for specific points in geological time
}
\examples{
pdb("Stegosauria")->Stegosauria
abdistr_(x=c(170:120), table=Stegosauria)
}
