\name{pers}
\alias{pers}
\title{WLE - Rasch Person Parameter}
\usage{
  pers(itempar, daten = NULL, incidenz = NULL,
    na_treat = NULL, limit = 1e-05, iter = 50,
    tecout = FALSE)
}
\arguments{
  \item{itempar}{The item parameter prior calculated or
  estimated. A list object of class \code{"pair"} as a
  result of applying the function \code{\link{pair}()} to
  the data. Or an 'ordinary' \code{"matrix"} with
  \code{nrow = k} (number of items) and \code{ncol = m}
  (maximum number of thresholds), holding the 'thurstonian'
  thresholds of the respective item. Some matrix entries
  may be \code{NA}, depending on the number of categories
  of the respective item.}

  \item{daten}{A \code{"matrix"} (or \code{"data.frame"})
  optionaly with named colums (names of items) and named
  rows (person IDs). This argument can be left empty when
  the argument itempar (above) is of class \code{"pair"}.
  \code{daten} holds polytomous or dichotomous (or mixted
  category numbers) responses of \code{n} respondents
  (rows) on \code{k} items (colums) coded starting with 0
  for lowest category to \code{m-1} for highest category,
  with m beeing a vector (with length k) with the number of
  categories for the respective item. Responses in
  \code{daten} must be stored as \code{"integers"} (not
  \code{"factors"} !) and may have missing values.}

  \item{incidenz}{This argument is only relevant when items
  are assigned to different booklets. For such a
  booklet-design a \code{"matrix"} should be assigned to
  this argument, with the same dimensions like
  \code{daten}, containig 0 and 1 integer codes, giving the
  information (for every person) if the respective item was
  in the respective booklet (coded 1) given to the person
  or not (coded 0).}

  \item{na_treat}{optionaly an integer (vector) defining
  the type of treatment to missing responses in the
  argument \code{daten}. If set to \code{na_treat=NULL}
  (default) missing responses are treated as missings and
  the respective person is assigned to an corresponding
  missing group for estimation. An option is to set
  \code{na_treat} to any integer value between 0 (lowest
  category) and the numeric code for the maximum ctaegory
  of the respective item.}

  \item{limit}{numeric giving the limit at which accuracy
  the WL-algorithm stops.}

  \item{iter}{numeric giving the maximum numer of iteration
  to perform.}

  \item{tecout}{logical default set to \code{FALSE}. If set
  to \code{TRUE} the result will be a (very) long list with
  estimation details for every case in \code{daten}. In
  case of a booklet-design the list entries will be divided
  by "booklet".}
}
\value{
  An object of class \code{c("pers", "data.frame")} or a
  (very long) \code{"list"} (when setting on
  \code{techout=TRUE}) containing the person parameters.
}
\description{
  This is the (new) main function for calculation of person
  estimates based on answering dichotomous or polytomous
  items according theRasch Model (Rasch, 1960) and Partial
  Credit Model (Masters, 1982), given the item parameters
  (object of class \code{"pair"} - as a result of
  \code{\link{pair}()}) and and the datamatrix (argument
  \code{daten}) containing the person respose vectors
  (rows), using an WL approach, introduced by Warm (1989).
}
\details{
  no detail in the moment.
}
\examples{
############
data(sim200x3)
result <- pers(itempar=pair(sim200x3))
summary(result)
plot(result)
}
\references{
  Masters, G. (1982). A Rasch model for partial credit
  scoring. \emph{Psychometrika, 47}(2), 149–174.

  Rasch, G. (1960). \emph{Probabilistic models for some
  intelligence and attainment tests.} Copenhagen: Danmarks
  pædagogiske Institut.

  Warm, T. A. (1989). Weighted likelihood estimation of
  ability in item response theory. \emph{Psychometrika,
  54}(3), 427–450.
}

