% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{project_pageviews}
\alias{project_pageviews}
\title{Retrieve Per-Project Pageview Counts}
\usage{
project_pageviews(project = "en.wikipedia", platform = "all",
  user_type = "all", granularity = "daily", start = "2015100100",
  end = NULL, reformat = TRUE, ...)
}
\arguments{
\item{project}{the name of the project, structured as \code{[language_code].[project]}
(see the default).}

\item{platform}{The platform the pageviews came from; one or more of  "all", "desktop", "mobile-web" and
"mobile-app". Set to "all" by default.}

\item{user_type}{the type of users. one or more of  "all", "user", "spider" or "bot". "all" by default.}

\item{granularity}{the granularity of data to return; do you want hourly or daily counts? Set
to "daily" by default.}

\item{start}{the start \code{YYYYMMDDHH} of the range you want to cover. This can be
easily grabbed from R date/time objects using \code{\link{pageview_timestamps}}}

\item{end}{the end \code{YYYYMMDDHH} of the range you want to cover. NULL by default, meaning
that it returns 1 day/hour of data (depending on the value passed to \code{granularity}).}

\item{reformat}{Whether to reformat the results as a \code{\link{data.frame}} or not. TRUE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
Retrieve pageview counts for a particular project.
}
\examples{
# Basic call
enwiki_1_october_pageviews <- project_pageviews()

# Break it down to hourly
enwiki_hourly <- project_pageviews(granularity = "hourly", end = "2015100123")

}
\seealso{
\code{\link{top_articles}} for the top articles per project in a given date range,
and \code{\link{article_pageviews}} for per-article pageviews.
}

