#' The `{pacta.loanbook}` logo, using ASCII or Unicode characters
#'
#' Use [cli::ansi_strip()] to get rid of the colors.
#'
#' @param unicode Whether to use Unicode symbols. Default is `TRUE` on UTF-8
#'   platforms.
#'
#' @family utility functions
#'
#' @export
#'
#' @return a `pacta_loanbook_logo` classed `cli_ansi_string` which will print
#' the PACTA logo in the console in interactive sessions.
#'
#' @examples
#' pacta_loanbook_logo()

pacta_loanbook_logo <- function(unicode = cli::is_utf8_output()) {
  logo <- c("\033[38;5;88m __\033[39m\033[38;5;124m__\033[39m\033[38;5;160m   \033[39m\033[38;5;203m _\033[39m\033[38;5;209m__\033[39m\033[38;5;216m___\033[39m\033[38;5;223m  \033[39m\033[38;5;230m___\033[39m\033[38;5;231m_ \033[39m\033[38;5;231m  \033[39m\033[38;5;253m __\033[39m\033[38;5;195m__\033[39m\033[38;5;153m__ \033[39m\033[38;5;117m _\033[39m\033[38;5;74m__\033[39m\033[38;5;32m___\033[39m\033[38;5;25m  \033[39m\033[38;5;24m   \033[39m\033[39m\n\033[38;5;88m/\\ \033[39m\033[38;5;124m _\033[39m\033[38;5;160m`\\ \033[39m\033[38;5;203m/\\\033[39m\033[38;5;209m  \033[39m\033[38;5;216m_  \033[39m\033[38;5;223m\\/\033[39m\033[38;5;230m\\  \033[39m\033[38;5;231m_`\033[39m\033[38;5;231m\\ \033[39m\033[38;5;253m/\\_\033[39m\033[38;5;195m_ \033[39m\033[38;5;153m _\\\033[39m\033[38;5;117m/\\\033[39m\033[38;5;74m  \033[39m\033[38;5;32m_  \033[39m\033[38;5;25m\\ \033[39m\033[38;5;24m   \033[39m\033[39m\n\033[38;5;88m\\ \\\033[39m\033[38;5;124m \\\033[39m\033[38;5;160mL\\ \033[39m\033[38;5;203m\\ \033[39m\033[38;5;209m\\ \033[39m\033[38;5;216m\\L\\\033[39m\033[38;5;223m \\\033[39m\033[38;5;230m \\ \033[39m\033[38;5;231m\\/\033[39m\033[38;5;231m\\_\033[39m\033[38;5;253m\\/_\033[39m\033[38;5;195m/\\\033[39m\033[38;5;153m \\/\033[39m\033[38;5;117m\\ \033[39m\033[38;5;74m\\ \033[39m\033[38;5;32m\\L\\\033[39m\033[38;5;25m \\\033[39m\033[38;5;24m   \033[39m\033[39m\n\033[38;5;88m \\ \033[39m\033[38;5;124m\\ \033[39m\033[38;5;160m,__\033[39m\033[38;5;203m/\\\033[39m\033[38;5;209m \\\033[39m\033[38;5;216m  _\033[39m\033[38;5;223m_ \033[39m\033[38;5;230m\\ \\\033[39m\033[38;5;231m \\\033[39m\033[38;5;231m/_\033[39m\033[38;5;253m/_ \033[39m\033[38;5;195m\\ \033[39m\033[38;5;153m\\ \\\033[39m\033[38;5;117m \\\033[39m\033[38;5;74m \\\033[39m\033[38;5;32m  _\033[39m\033[38;5;25m_ \033[39m\033[38;5;24m\\  \033[39m\033[39m\n\033[38;5;88m  \\\033[39m\033[38;5;124m \\\033[39m\033[38;5;160m \\/\033[39m\033[38;5;203m  \033[39m\033[38;5;209m\\ \033[39m\033[38;5;216m\\ \\\033[39m\033[38;5;223m/\\\033[39m\033[38;5;230m \\ \033[39m\033[38;5;231m\\ \033[39m\033[38;5;231m\\L\033[39m\033[38;5;253m\\ \\\033[39m\033[38;5;195m \\\033[39m\033[38;5;153m \\ \033[39m\033[38;5;117m\\ \033[39m\033[38;5;74m\\ \033[39m\033[38;5;32m\\ \\\033[39m\033[38;5;25m/\\\033[39m\033[38;5;24m \\ \033[39m\033[39m\n\033[38;5;88m   \033[39m\033[38;5;124m\\ \033[39m\033[38;5;160m\\_\\\033[39m\033[38;5;203m  \033[39m\033[38;5;209m \\\033[39m\033[38;5;216m \\_\033[39m\033[38;5;223m\\ \033[39m\033[38;5;230m\\_\\\033[39m\033[38;5;231m \\\033[39m\033[38;5;231m__\033[39m\033[38;5;253m__/\033[39m\033[38;5;195m  \033[39m\033[38;5;153m\\ \\\033[39m\033[38;5;117m_\\\033[39m\033[38;5;74m \\\033[39m\033[38;5;32m \\_\033[39m\033[38;5;25m\\ \033[39m\033[38;5;24m\\_\\\033[39m\033[39m\n\033[38;5;88m   \033[39m\033[38;5;124m \\\033[39m\033[38;5;160m/_/\033[39m\033[38;5;203m  \033[39m\033[38;5;209m  \033[39m\033[38;5;216m\\/_\033[39m\033[38;5;223m/\\\033[39m\033[38;5;230m/_/\033[39m\033[38;5;231m\\/\033[39m\033[38;5;231m__\033[39m\033[38;5;253m_/ \033[39m\033[38;5;195m  \033[39m\033[38;5;153m \\/\033[39m\033[38;5;117m_/\033[39m\033[38;5;74m  \033[39m\033[38;5;32m\\/_\033[39m\033[38;5;25m/\\\033[39m\033[38;5;24m/_/\033[39m\033[39m\n")

  structure(cli::col_blue(logo), class = "pacta_loanbook_logo")
}

#' @export

print.pacta_loanbook_logo <- function(x, ...) {
  cat(x, ..., sep = "\n")
  invisible(x)
}
