% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pact.R
\name{pact.fit}
\alias{pact.fit}
\title{Fits a predictive model to the full dataset}
\usage{
pact.fit(Y, Xf = NULL, Xv, Treatment, family = c("binomial", "cox"),
  varSelect = c("none", "univar", "lasso"), nsig = ifelse(varSelect ==
  "univar", ifelse(nCovarv < 10, 3, 10), NA),
  cvfolds.varSelect = ifelse(varSelect == "lasso", 5, NA),
  which.lambda = ifelse(varSelect == "lasso", ifelse(nCovarv < 10, "min",
  "1se"), NA), penalty.scaling = ifelse(varSelect == "lasso", 0.5, NA))
}
\arguments{
\item{Y}{Response variable. For \code{family='binomial'}, Y should be a factor with two 
levels. For \code{family='cox'}, Y should be a two-column matrix with columns named 'time' 
and 'status'. The latter is a binary variable, with '1' indicating death, and '0' 
indicating right censored.}

\item{Xf}{An optional dataframe of the prognostic covariates that are not subject to variable
selection and always fixed to remain in the model. Default is NULL (no variable).}

\item{Xv}{The main dataframe of covariates that are to be used for predictive model development. 
Variable selection options affect only the variables in Xv. Xv cannot be NULL.}

\item{Treatment}{The treatment assignment indicator. A factor with two levels.
'0' indicating control (C) and '1' indicating experimental (E) treatment.}

\item{family}{Type of the response variable. See above. Possible values are 'binomial'
or 'cox'.}

\item{varSelect}{The variable selection method. Possible values are "none","univar" or "lasso".}

\item{nsig}{The number of covariates to use in the model for varSelect="univar". 
Defaults to 3 if the number of candidate covariates is less than 10, else defaults to 10.}

\item{cvfolds.varSelect}{The number of folds in the internal cross-validation loop for
variable selection with varSelect="lasso". Default is 5.}

\item{which.lambda}{Used with variable selection with varSelect="lasso". Defaults to "min" 
if the number of candidate covariates is less than 10, else defaults to "1se". See Details.}

\item{penalty.scaling}{Ratio of shrinkage applied for main coefficients to shrinkage applied 
for interaction coefficients. Used with varSelect="lasso". Default is 0.5. See Details.}
}
\value{
An object of class 'pact' which is a list with the following components:

\item{reg}{The fitted regression model}

\item{family}{Type of the response variable}

\item{Y}{The response variable used}

\item{Xf}{The dataframe of prognostic covariates}

\item{Xv}{The dataframe of candidate predictive variables}

\item{Treatment}{The treatment assignment indicator used}

\item{nCovarf}{The number of variables in Xf}

\item{nCovarv}{The number of variables in Xv}

\item{varSelect}{The variable selection method used}

\item{nsig, cvfolds.varSelect, which.lambda, penalty.scaling}{The variable selection parameters used}

\item{call}{The call that produced the return object}
}
\description{
\code{pact.fit} Fits a predictive model using data on all subjects. Currently supports  
Cox PH and logistic regression models for 'survival' and 'binary' response types 
respectively.
}
\details{
A Cox proportional hazards (PH) or a logistic regression model is 
developed for data with survival and binary response respectively. Data from subjects 
in both 'experimental' (E) and 'control' (C) groups from a RCT is used for model
development. Main effect of treatment, main effect of prognostic covariates, 
main effects and treatment by covariate interaction terms of candidate predictive  
covariates are considered in the model. Methods for variable selection can be optionally   
specified by the user for candidate predictive covariates (useful for high-dimensional  
covariates). Current options for variable selection include "univar" and "lasso". 
In the case of "univar", the number of predictive covariates (nsig) to be included in the
model is specified by the user. A univariate selection procedure is applied to identify 
covariates that have the lowest treatment*covariate interaction p-values. The 
predictive model is then developed using the main effect of treatment, main effects 
of prognostic covariates, main effects of the nsig predictive covariates and treatment 
by covariate interaction terms for nsig predictive covariates.

In the case of "lasso", an internal cross-validation loop
is used to find the penalty value that minimizes the cross-validated error. The user can 
choose either the value of the penalty 'lambda' as the penalty that minimizes the 
cross-validated  error ("lambda.min") or the largest penalty for which the cross-validated  
error is within 1 standard error of the minimum ("lambda.1se"). Also, in the case of "lasso",
differential shrinkage can be specified for main effect and interaction effect predictive 
coefficients by specifying a value for the ratio of shrinkage for main coefficients to 
shrinkage for interaction coefficients. Internally, 'lambda' is scaled using this ratio to 
allow for the differential shrinkage of main and interaction coefficients.The penalty 
factors affect only variables in Xv and not Xf.
}
\examples{
data(prostateCancer)
Y <- prostateCancer[,3:4]
Xf <- prostateCancer[,7:8]
Xv <- prostateCancer[,c(5:6,9)]
Treatment <- as.factor(prostateCancer[,2])
pact.fit(Y=Y, Xf=Xf, Xv=Xv, Treatment=Treatment, family="cox",varSelect="univar")
}
\author{
Jyothi Subramanian and Richard Simon
\cr Maintainer: Jyothi Subramanian <\email{subramanianj01@gmail.com}>
}
\keyword{pact,}
\keyword{pact.fit}

