% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{pac_deps_heavy}
\alias{pac_deps_heavy}
\title{Package direct dependencies and number of dependencies for each of them}
\usage{
pac_deps_heavy(
  pac,
  fields = c("Depends", "Imports", "LinkingTo"),
  lib.loc = .libPaths(),
  base = FALSE,
  local = FALSE,
  repos = pacs::biocran_repos()
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{fields}{\code{character} vector listing the types of dependencies, a subset of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{base}{\code{logical} if to add base packages too. If \code{TRUE} then \code{pacs::pacs_base()} are taken into account. Default: \code{FALSE}}

\item{local}{\code{logical} if to use local repository (or newest remote packages). Default: \code{FALSE}}

\item{repos}{\code{character} vector of repositories URLs to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}
}
\value{
\code{data.frame} with three columns \code{c("Package", "NrDeps", "NrUniqueDeps")}: package name, number of dependencies and number of unique dependencies (not shared by other direct dependencies).
}
\description{
A higher-level function, build from \code{pacs::pacs_deps} and \code{tools::package_dependencies}.
A tool to identify a main sources of dependencies, which direct dependencies are the heaviest one.
}
\note{
Please take into account that the sum of the dependencies is not equal to the number of dependencies of the main package,
because some dependencies are overlapping.
}
\examples{
\dontrun{
pacs::pac_deps_heavy("caret")
pacs::pac_deps_heavy("dplyr")
}
}
