% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comapre.R
\name{pac_compare_namespace}
\alias{pac_compare_namespace}
\title{Compare NAMESPACE exports between specific CRAN packages versions}
\usage{
pac_compare_namespace(
  pac,
  old = NULL,
  new = NULL,
  lib.loc = .libPaths(),
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{old}{\code{character} an old version of package, default local version. Default: \code{NULL}}

\item{new}{\code{character} a new version of package, default newest version. Default: \code{NULL}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{repos}{\code{character} vector repositories URLs to use. Used only for the validation. Default \verb{https://cran.rstudio.com/}}
}
\value{
\code{list} with \code{c("imports", "exports", "exportPatterns", "importClasses", "importMethods", "exportClasses", "exportMethods", "exportClassPatterns", "dynlibs", "S3methods")} slots, and added and removed ones for each of them.
}
\description{
using the remote github CRAN mirror to compare NAMESPACE exports between specific packages versions.
}
\examples{
\dontrun{
pacs::pac_compare_namespace("shiny", "1.0.0", "1.6.0")
pacs::pac_compare_namespace("shiny", "1.0.0", "1.6.0")$exports
# local version to newest one
pacs::pac_compare_namespace("shiny")
}
}
