% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_last.R
\name{pac_isin}
\alias{pac_isin}
\title{Checking if a package is in repositories}
\usage{
pac_isin(pac, repos = biocran_repos())
}
\arguments{
\item{pac}{character a package name.}

\item{repos}{character vector base URLs of the repositories to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}
}
\value{
logical if a package is inside repositories.
}
\description{
using \code{utils::available.packages} to check if package is in repositories.
}
\note{
Results are cached for 1 hour with \code{memoise} package.
}
\examples{
\dontrun{
pac_isin("dplyr")
pac_isin("dplyr", repos = "https://cran.rstudio.com/")
pac_isin("dplyr", repos = biocran_repos()[grep("Bio", names(biocran_repos()))])
}
}
