% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeduration.R
\name{pac_health}
\alias{pac_health}
\title{Package health state at a specific Date or for a specific version}
\usage{
pac_health(
  pac,
  version = NULL,
  at = NULL,
  limit = 14,
  lib.loc = NULL,
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{pac}{character a package name.}

\item{version}{character version of package. Default: NULL}

\item{at}{Date old version of package. Default: NULL}

\item{limit}{numeric at least days to treat as healthy. Default: 14}

\item{lib.loc}{character vector. Is omitted for non NULL version. Default: NULL}

\item{repos}{character the base URL of the repositories to use. Default \verb{https://cran.rstudio.com/}}
}
\value{
logical if package is healthy.
}
\description{
using CRAN website to get a package version/versions used at a specific Date interval.
A healthy package was published for more than x days, where default is 14 days.
CRAN team gives around one/two week to resolved a package which gave errors under the check page.
}
\note{
Function will scrap two/tree CRAN URLS. Works only with CRAN packages.
The newest release are checked for warnings/errors on R CRAN check page.
Please as a courtesy to the R CRAN, don't overload their server by constantly using this function.
Results are cached for 1 hour with \code{memoise} package, memory cache.
}
\examples{
pac_health("memoise")
pac_health("dplyr", version = "0.8.0")
}
