% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitlab.R
\name{provide_gitlab_url}
\alias{provide_gitlab_url}
\title{Provide a \verb{gitlab} \acronym{URL} for a Given Path}
\usage{
provide_gitlab_url(path = ".")
}
\arguments{
\item{path}{Path to the package directory (see
\code{\link[devtools:as.package]{devtools::as.package}}).}
}
\value{
a character string giving a \verb{github} \acronym{URL}.
}
\description{
Provide a \verb{gitlab} \acronym{URL} for a Given Path
}
\examples{
path <- file.path(tempdir(), "myPackage")
unlink(path, recursive = TRUE)
usethis::create_package(path, open = FALSE)
try(provide_gitlab_url(path))
gert::git_init(path)
provide_gitlab_url(path)
invisible(desc::desc_set(Package = "bar", file = path))
provide_gitlab_url(path)
}
\keyword{internal}
