% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{get_pkg_archive_path}
\alias{get_pkg_archive_path}
\title{Create a Package's Archive Path From the Package's \file{DESCRIPTION}}
\usage{
get_pkg_archive_path(path = ".", absolute = TRUE)
}
\arguments{
\item{path}{Path to the package directory (see
\code{\link[devtools:as.package]{devtools::as.package}}).}

\item{absolute}{Return the absolute path?}
}
\value{
Path to the package's archive file.
}
\description{
The archive file does not have to exist. Use
\code{file.exists(get_pkg_archive_path())} to test existence.
}
\examples{
package_path <- file.path(tempdir(), "anRpackage")
usethis::create_package(path = package_path)
print(tarball <- get_pkg_archive_path(package_path))
file.exists(tarball)
}
