% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{PM.play}
\alias{PM.play}
\title{Play a Process Mining model}
\usage{
PM.play(PM.obj, numberOfPlays)
}
\arguments{
\item{PM.obj}{a Process Mining model previously instantiated via the appropriate class (in example \code{alphaAlgorithm()}  or \code{firstOrderMarkovModel()}) or \code{AA.builder();} wrapper function}

\item{numberOfPlays}{the number of sequences you want to obtain}
}
\value{
a list containing the generated words
}
\description{
This function wraps the \code{<object>::play( ... ) } method and runs many times a Process Mining model and returns the generates processes.
}
\examples{
\dontrun{
# Instantiate a'firstOrderMarkovModel' model
obj.LD<-LD.builder()

# Load a CSV into the loader
LD.load.csv(loader.obj = obj.LD ,nomeFile = "../csv/dati_retto.csv",
              IDName = "CODICE_SANITARIO_ADT",EVENTName = "CAT1")

# Instantiate a PM model
obj.PM <-PM.builder(kindOfObject = "firstOrderMarkovModel")

# Load the PM model
PM.loadDataset(PM.obj = obj.PM,dataList = LD.getData(loader.obj = obj.LD))

# train it
PM.trainModel(PM.obj = obj.PM)#' 

# play the model 5 times
PM.play(PM.obj = obj.PM,numberOfPlays = 5)
} 
}

