% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WCSCapabilities.R
\docType{class}
\name{WCSCapabilities}
\alias{WCSCapabilities}
\title{WCSCapabilities}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Coverage Service Get Capabilities document.
}
\description{
WCSCapabilities

WCSCapabilities
}
\examples{
\dontrun{
   WCSCapabilities$new("http://localhost:8080/geoserver/wcs", serviceVersion = "2.0.1")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GetCapabilities}
\keyword{OGC}
\keyword{WCS}
\section{Super classes}{
\code{\link[ows4R:OGCAbstractObject]{ows4R::OGCAbstractObject}} -> \code{\link[ows4R:OWSCapabilities]{ows4R::OWSCapabilities}} -> \code{WCSCapabilities}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WCSCapabilities-new}{\code{WCSCapabilities$new()}}
\item \href{#method-WCSCapabilities-getCoverageSummaries}{\code{WCSCapabilities$getCoverageSummaries()}}
\item \href{#method-WCSCapabilities-findCoverageSummaryById}{\code{WCSCapabilities$findCoverageSummaryById()}}
\item \href{#method-WCSCapabilities-clone}{\code{WCSCapabilities$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="ERROR"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-ERROR'><code>ows4R::OGCAbstractObject$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="INFO"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-INFO'><code>ows4R::OGCAbstractObject$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="WARN"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-WARN'><code>ows4R::OGCAbstractObject$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="encode"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-encode'><code>ows4R::OGCAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClass"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClass'><code>ows4R::OGCAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClassName"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClassName'><code>ows4R::OGCAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getNamespaceDefinition"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getNamespaceDefinition'><code>ows4R::OGCAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="isFieldInheritedFrom"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-isFieldInheritedFrom'><code>ows4R::OGCAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="logger"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-logger'><code>ows4R::OGCAbstractObject$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getClient"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getClient'><code>ows4R::OWSCapabilities$getClient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getOWSVersion"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getOWSVersion'><code>ows4R::OWSCapabilities$getOWSVersion()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getOperationsMetadata"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getOperationsMetadata'><code>ows4R::OWSCapabilities$getOperationsMetadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getRequest"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getRequest'><code>ows4R::OWSCapabilities$getRequest()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getService"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getService'><code>ows4R::OWSCapabilities$getService()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceIdentification"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceIdentification'><code>ows4R::OWSCapabilities$getServiceIdentification()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceProvider"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceProvider'><code>ows4R::OWSCapabilities$getServiceProvider()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceVersion"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceVersion'><code>ows4R::OWSCapabilities$getServiceVersion()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getUrl"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getUrl'><code>ows4R::OWSCapabilities$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="setClient"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-setClient'><code>ows4R::OWSCapabilities$setClient()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCapabilities-new"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCapabilities-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{WCSCapabilities} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCapabilities$new(url, version, client = NULL, logger = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{version}}{version}

\item{\code{client}}{an object of class \link{WCSClient}}

\item{\code{logger}}{logger type \code{NULL}, "INFO" or "DEBUG"}

\item{\code{...}}{any other parameter to pass to \link{OWSGetCapabilities} service request}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCapabilities-getCoverageSummaries"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCapabilities-getCoverageSummaries}{}}}
\subsection{Method \code{getCoverageSummaries()}}{
Get coverage summaries
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCapabilities$getCoverageSummaries()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a \code{list} of \link{WCSCoverageSummary} objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCapabilities-findCoverageSummaryById"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCapabilities-findCoverageSummaryById}{}}}
\subsection{Method \code{findCoverageSummaryById()}}{
Finds a coverage by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCapabilities$findCoverageSummaryById(expr, exact = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{expr}

\item{\code{exact}}{exact matching? Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCapabilities-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCapabilities-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCapabilities$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
