% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_up-remove_prefix.R
\name{remove_prefix}
\alias{remove_prefix}
\title{Remove prefices from column names.}
\usage{
remove_prefix(data, prefices, sep = ".")
}
\arguments{
\item{data}{data frame}

\item{prefices}{vector of prefices to be removed from column names}

\item{sep}{prefix separator}
}
\value{
data frame with updated column names
}
\description{
Remove prefices from column names.
}
\examples{
x <- data.frame(main.temp = 1:10, sys.msg = "OK", cnt = 10:1)
names(x)
remove_prefix(x, c("main", "sys")) \%>\% names()
}

