% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bimac.R
\docType{data}
\name{bimac}
\alias{bimac}
\title{Anolis bimaculatus lizard size data}
\format{
A data frame with 45 observations on the following 11 variables.
\itemize{
\item \code{node}: Labels for the nodes.
\item \code{spcode}: Two-letter code for each taxon.
\item \code{species}: Species names for extant species.
\item \code{island}: Name of the island on which the population is found.
\item \code{size}: Body size (head length in mm) of extant species.
\item \code{ancestor}: Ancestral node.
\item \code{time}: Time of node.
\item \code{OU.1}: a factor with levels \code{ns}
\item \code{OU.3}: a factor with levels \code{small}, \code{medium}, \code{large}
\item \code{OU.4}: a factor with levels \code{small}, \code{medium}, \code{large}, \code{anc}
\item \code{OU.LP}: a factor with levels \code{small}, \code{medium}, \code{large}
}
}
\source{
\Butler2004
}
\description{
This is the \emph{Anolis bimaculatus} dataset used in Butler & King (2004).
It is used to test a hypothesis of character displacement using an interspecific dataset of body sizes and current data on sympatry/allopatry.
}
\details{
Explanations of the data follow:
\itemize{
\item \strong{Body size.}
We use the phenotypic data and phylogeny of Losos (1990), which employed the head lengths (of males) as a proxy for body size.
In this group of lizards, head length correlates very strongly with snout-to-vent length and the cube root of mass, which are standard measures of body size.
The data are head lengths in mm; note that we use the log of this value in analyses.
\item \strong{Tree structure.}
The phylogenetic tree is encoded via three variables:
\code{node}, \code{ancestor}, and \code{time}.
The \code{node} variable gives a name to each node.
The \code{ancestor} variable names the ancestor of each node.
The root node has no ancestor (i.e., \code{ancestor=NA}).
The variable \code{time} specifies the temporal location of each node, the root node being at time 0.
\item \strong{Specifications of selective regimes.}
(Columns \code{OU.1}, \code{OU.3}, \code{OU.4}, \code{OU.LP}).
These columns are factors, the levels of which correspond to the \dQuote{paintings} of the respective adaptive regime hypotheses onto the phylogeny (see \code{\link[=paint]{paint()}}).
Each selective regime is named (small, medium, large, etc.).
Each column corresponds to a different painting of the selective regimes, and thus to a different hypothesis.
In this example, there are 3 alternative models (see Butler & King 2004): \code{OU.4} is 4-regime model, \code{OU.3} is 3-regime model (all ancestors are medium), \code{OU.LP} is the linear parsimony model.
\item \strong{Other variables.}
In addition to the above, there is a two-letter code for each taxon (\code{spcode}) and the name of the island on which the taxon is found (\code{island}).
}
}
\examples{
## Analysis of Anolis bimaculatus data
tree <- with(bimac,ouchtree(node,ancestor,time/max(time),spcode))
plot(tree,node.names=TRUE)

h1 <- brown(log(bimac['size']),tree)
h1
plot(h1)

h2 <- hansen(log(bimac['size']),tree,bimac['OU.1'],sqrt.alpha=1,sigma=1)
h2
plot(h2)

h3 <- hansen(log(bimac['size']),tree,bimac['OU.3'],sqrt.alpha=1,sigma=1)
h3
plot(h3)

h4 <- hansen(log(bimac['size']),tree,bimac['OU.4'],sqrt.alpha=1,sigma=1)
h4
plot(h4)

h5 <- hansen(log(bimac['size']),tree,bimac['OU.LP'],sqrt.alpha=1,sigma=1,reltol=1e-5)
h5 <- update(h5,method='subplex',reltol=1e-11,parscale=c(0.1,0.1),hessian=TRUE)
h5
plot(h5)

simdat <- simulate(h5,nsim=10)
hsim <- update(h5,data=simdat[[1]])
summary(hsim)
bsim <- update(h1,data=simdat[[1]])
summary(bsim)
}
\references{
\Lazell1972

\Losos1990
}
\seealso{
Other examples: 
\code{\link{anolis.ssd}},
\code{\link{ouch-package}}
}
\author{
Marguerite A. Butler and Aaron A. King
}
\concept{examples}
\keyword{models}
