% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{ouch-package}
\alias{ouch-package}
\title{Ornstein-Uhlenbeck methods for comparative phylogenetic hypotheses}
\description{
The \pkg{ouch} package provides facilities for phylogenetic comparative analysis based on Ornstein-Uhlenbeck models of trait evolution along a phylogeny.
Multivariate data and complex adaptive hypotheses are supported.
}
\section{Classes}{

The basic class, \code{ouchtree}, is provided to encode a
phylogenetic tree.  Plot and print methods are provided.

The class \code{browntree} derives from class \code{ouchtree} and encodes
the results of fitting a Brownian Motion model to data.

The class \code{hansentree} derives from class \code{ouchtree} and encodes
the results of fitting a Hansen model to data.
}

\section{Detailed Documentation}{

\describe{
  \item{Phylogenies in \pkg{ouch} format}{\code{\link{ouchtree}}, \code{\link{ape2ouch}}}
  \item{Brownian motion models}{\code{\link{brown}}}
  \item{Ornstein-Uhlenbeck models}{\code{\link{hansen}}}
  \item{Simulation of models}{\code{\link[ouch:simulate]{simulate}}}
  \item{Display of data}{\code{\link[ouch:plot]{plot}}}
  \item{Examples}{\code{\link{anolis.ssd}}, \code{\link{bimac}}}
}
}

\references{
\Butler2004

\Cressler2015
}
\author{
Aaron A. King
}
\keyword{models}
