% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{PrepLabels}
\alias{PrepLabels}
\title{Prepare variable labels}
\usage{
PrepLabels(labelFl, idx = 1:2)
}
\arguments{
\item{labelFl}{Either the path of a dataset (a csv file) containing
labels, an R object convertible to \code{data.table} (e.g., data frame) or 
\code{NULL}. If \code{NULL}, no labels will be used. The label dataset must 
contain at least 2 columns: \code{varCol} (variable names) and 
\code{labelCol} (variable labels).}

\item{idx}{A vector of length 2, giving column index of variable names (first
position) and labels (second position).}
}
\value{
A data table formated for use by the \code{\link{vlm}} function.
}
\description{
This function prepares a dataset containing variable labels for use by 
the main plotting function \code{\link{vlm}}. The input must contain 
variables' names in the first column and labels in the second column. All other 
columns will be dropped. Special characters will create errors and should 
be stripped outside of R. All labels will be truncated at 145 characters.
}
\section{License}{
 
Copyright 2017 Capital One Services, LLC Licensed under the
Apache License, Version 2.0 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of the 
License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
applicable law or agreed to in writing, software distributed under the
License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
}

\examples{
data(bankLabels)
bankLabels <- PrepLabels(bankLabels)
}
\seealso{
Functions depend on this function:
         \code{\link{PrintPlots}},
         \code{\link{vlm}}.
}
