% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bookdown_to_leanpub.R
\name{bookdown_to_leanpub}
\alias{bookdown_to_leanpub}
\title{Convert Bookdown to Leanpub}
\usage{
bookdown_to_leanpub(
  path = ".",
  render = TRUE,
  output_dir = "manuscript",
  make_book_txt = FALSE,
  quiz_dir = "quizzes",
  run_quiz_checks = FALSE,
  remove_resources_start = FALSE,
  verbose = TRUE,
  footer_text = NULL,
  clean_up = FALSE
)
}
\arguments{
\item{path}{path to the bookdown book, must have a `_bookdown.yml` file}

\item{render}{if `TRUE`, then [bookdown::render_book()] will be run on each Rmd.}

\item{output_dir}{output directory to put files.  It should likely be
relative to path}

\item{make_book_txt}{Should [ottrpal::bookdown_to_book_txt()] be run
to create a `Book.txt` in the output directory?}

\item{quiz_dir}{directory that contains the quiz .md files that should be
checked and incorporated into the Book.txt file. If you don't have quizzes,
set this to NULL}

\item{run_quiz_checks}{TRUE/FALSE run quiz checks}

\item{remove_resources_start}{remove the word `resources/` at the front
of any image path.}

\item{verbose}{print diagnostic messages}

\item{footer_text}{Optionally can add a bit of text that will be added to the
end of each file before the references section.}

\item{clean_up}{TRUE/FALSE the old output directory should be deleted and
everything created fresh.}
}
\value{
A list of output files and diagnostics
}
\description{
Convert Bookdown to Leanpub
}
