% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genetic.optim.IPS.r
\name{Genetic.optim.IPS}
\alias{Genetic.optim.IPS}
\title{The optimal treatment regime based on the (S)IPS estimator.}
\usage{
Genetic.optim.IPS(datalist, ps, t0, smooth = TRUE)
}
\arguments{
\item{datalist}{A list used to calculate the (S)IPS estimator including treatment named \code{a}, observed time named \code{obs.t}, censoring indicator (0, censored) named \code{delta}, and baseline covariates used to assign treatment named \code{l}.}

\item{ps}{A list including the probability of receiving treatment given baseline covariates named \code{fal}. \code{\link[otrKM]{Fps.IPS}} can produce \code{ps} by positing logistic model.}

\item{t0}{A predetermined time.}

\item{smooth}{A logic variable indicating wether a smoothed version should be used.}
}
\value{
A numeric vector in which the last number is the estimated optimal t0-year survival probability and the others are the estimated parameter of the optimal treatment regime.
}
\description{
Given a predetermined t0, estimate the optimal treatment regime by maximizing t0-year survival probability based on the (S)IPS estimator.
}
\details{
More details can be found in references.
}
\examples{
# load data
data(simulation)

# convert the data into a datalist
datalist=list(z=simulation$Instrument,a=simulation$Treatment,
              obs.t=simulation$Survival,delta=simulation$Status,
              l=cbind(simulation$Covariate1,simulation$Covariate2))

# predetermined t0
t0=5

# calculate ps
ps=Fps.IPS(datalist)

Genetic.optim.IPS(datalist, ps, t0, smooth=TRUE)
}
\references{
{Jiang, R., Lu, W., Song, R., and Davidian, M. (2017) On estimation of optimal treatment regimes for maximizing t‐year survival probability. \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, \bold{79:} 1165-1185. DOI:10.1111/rssb.12201}
}
