% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{Collecting Telemetry Data}
\alias{Collecting Telemetry Data}
\alias{collecting}
\title{Collecting Telemetry Data}
\value{
Not applicable.
}
\description{
This page is about collecting telemetry data from instrumented R
packages. If you need help with instrumenting your R package, see
\link[otel:Getting Started]{Getting Started} in the otel package.
}
\section{Usage}{
\itemize{
\item Instrument your R package or project using the
\href{https://github.com/r-lib/otel}{otel} package.
Alternatively, use
\link[otel:Zero Code Instrumentation]{Zero Code Instrumentation} to
automatically instrument selected packages.
\item Install the otelsdk package.
\item Choose an exporter from the otelsdk package. The \code{http} exporter sends
OpenTelemetry output through OTLP/HTTP.
\item Set the \code{OTEL_TRACES_EXPORTER} environment variable to point to the
exporter of your choice. E.g. for OTLP/HTTP set \code{OTEL_TRACES_EXPORTER=http}.
\item If you are sending telemetry data through HTTP, then you typically need
to configure the URL of your OpenTelemetry collector, and you possibly
also need to supply a token in an HTTP header, possibly some resource
attributes. Follow the instructions of the provider of your collector.
They typically don't have instructions for R, but generic instructions
about environment variables will work for the otelsdk R package. E.g. for
\href{https://grafana.com/}{Grafana} you need something like

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_EXPORTER_OTLP_PROTOCOL="http"
OTEL_EXPORTER_OTLP_ENDPOINT="https://otlp-gateway-prod-eu-central-0.grafana.net/otlp" \\
OTEL_RESOURCE_ATTRIBUTES="service.name=<name-of-your-app>,service.namespace=<name-of-your-namespace>,deployment.environment=test"
OTEL_EXPORTER_OTLP_HEADERS="Authorization=Basic\%20<base64-encoded-token>"
}\if{html}{\out{</div>}}

See more examples below.
\item See all \link[otelsdk:Environment Variables]{environment variables} and
the manual of your chosen provider for details on configuring otelsdk
exporters.
\item Start R and your app. Telemetry data will be exported to the chosen exporter.
}
}

\section{Setup}{
\subsection{Setup for remote collectors}{

There are a lot of services that offer an OpenTelemetry collector for
tracers, logs and metrics, many of them supporting all three of them.
There are also local apps that work as a collector. We tried otelsdk with
the following ones:
\subsection{\href{https://grafana.com/}{Grafana}}{

Follow the \href{https://grafana.com/docs/grafana-cloud/send-data/otlp/send-data-otlp/#manual-opentelemetry-setup-for-advanced-users}{documentation}.
Create an API token. You'll need to use the Grafana instrance ID as your
username, and the token as the password in HTTP Basic auth. E.g. in R do
this to get the base64 encoded token. \code{instance-id} is a (currently seven
digit) number and a string with a \code{glc_} prefix.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{openssl::base64_encode("<instance-id>:<api-token>")
}\if{html}{\out{</div>}}

Then use this encoded token to set the \code{Authorization} header:

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_EXPORTER_OTLP_PROTOCOL="http"
OTEL_EXPORTER_OTLP_ENDPOINT="https://otlp-gateway-prod-eu-central-0.grafana.net/otlp" \\
OTEL_EXPORTER_OTLP_HEADERS="Authorization=Basic\%20<base64-encoded-token>"
OTEL_RESOURCE_ATTRIBUTES="service.name=<name-of-your-app,service.namespace=<name-of-your-namespace>,deployment.environment=test"
}\if{html}{\out{</div>}}

Your endpoint URL is probably different, use the one that you see on your
dashboard.

If you want to export logs and/or metrics, set these environment variables,
respectively:

\if{html}{\out{<div class="sourceCode">}}\preformatted{
OTEL_LOGS_EXPORTER=http
OTEL_LOG_LEVEL=debug
OTEL_METRICS_EXPORTER=http
}\if{html}{\out{</div>}}

It also makes sense to set the desired log level.

Grafana suggests running an OpenTelemetry collector on premise instead of
sending telemetry data to them directly. But nevertheless you can start out
without running your own collector, they call this "quick start" mode.
}

\subsection{\href{https://pydantic.dev/logfire}{Pydantic Logfire}}{

Create a project and a write token. Note that the URLs you need to use
are different if you are within the EU! You probably need to replace \code{us}
with \code{eu} in the URL if you are in the EU. Set these environment variables:

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_TRACES_EXPORTER=http
OTEL_EXPORTER_OTLP_ENDPOINT="https://logfire-us.pydantic.dev"
OTEL_EXPORTER_OTLP_HEADERS="Authorization=<your-write-token>"
}\if{html}{\out{</div>}}

For logs also set \code{OTEL_LOGS_EXPORTER} and the desired log level:

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_LOGS_EXPORTER=http
OTEL_LOG_LEVEL=debug
}\if{html}{\out{</div>}}

For exporting metrics also set

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_METRICS_EXPORTER=http
}\if{html}{\out{</div>}}
}

}

\subsection{Setup for local collectors}{
\subsection{\href{https://github.com/ymtdzzz/otel-tui}{otel-tui}}{

\code{otel-tui} is a terminal app that supports traces, logs and metrics.
It is great for development, as you can keep all your telemetry local while
instrumenting your package or app. Follow the installation instructions and
then run the app from a terminal:

\if{html}{\out{<div class="sourceCode">}}\preformatted{otel-tui
}\if{html}{\out{</div>}}

It listens on the default port, so the setup is very simple, set these
environment variables (or a subset if you don't want metrics or logs):

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_TRACES_EXPORTER=http
OTEL_LOGS_EXPORTER=http
OTEL_LOG_LEVEL=debug
OTEL_METRICS_EXPORTER=http
}\if{html}{\out{</div>}}
}

\subsection{\href{https://github.com/CtrlSpice/otel-desktop-viewer}{otel-desktop-viewer}}{

\code{otel-desktop-viewer} is similar to \code{otel-tui}, but has a web UI. Follow
the installation instructions and start the app from a terminal:

\if{html}{\out{<div class="sourceCode">}}\preformatted{otel-desktop-viewer
}\if{html}{\out{</div>}}

It should start a new windows or tab in your local web browser. Set the
usual environment variable for your R app:

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_TRACES_EXPORTER=http
}\if{html}{\out{</div>}}
}

\subsection{\href{https://www.jaegertracing.io/}{Jaeger}}{

If you have Docker, you can start a
\href{https://www.jaegertracing.io/}{Jaeger} container on the default port:

\if{html}{\out{<div class="sourceCode">}}\preformatted{docker run --rm --name jaeger \\
 -p 16686:16686 \\
 -p 4317:4317 \\
 -p 4318:4318 \\
 -p 5778:5778 \\
 -p 9411:9411 \\
 jaegertracing/jaeger:2.4.0
}\if{html}{\out{</div>}}

Go to \verb{http://localhost:16686/} to view the Jaeger UI.
}

\subsection{\href{https://github.com/SigNoz/signoz}{SigNoz}}{

To run SigNoz locally with Docker, clone the repository at
https://github.com/SigNoz/signoz:

\if{html}{\out{<div class="sourceCode">}}\preformatted{git clone --depth 1 https://github.com/SigNoz/signoz
}\if{html}{\out{</div>}}

and then run Docker Compose from the \verb{deploy/docker/} subdirectory:

\if{html}{\out{<div class="sourceCode">}}\preformatted{cd deploy/docker
docker compose up
}\if{html}{\out{</div>}}

Go to \verb{http://localhost:8080} to see the SigNoz UI.
}

}
}

\examples{
# See above
}
