% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ot.R
\name{setTags}
\alias{setTags}
\alias{baggage}
\alias{baggage<-}
\alias{getContext}
\alias{otlog}
\alias{log}
\alias{finish}
\title{Span Object Methods}
\usage{
setTags(span, ...)

baggage(span, ...)

baggage(span, ...) <- value

getContext(span, ...)

otlog(span, ..., timestamp = Sys.time())

log(span, ..., timestamp = Sys.time())

finish(span, finishTime = Sys.time())
}
\arguments{
\item{span}{a span object}

\item{...}{defined by implementation}

\item{value}{the baggage data}

\item{timestamp}{a POSIXct timestamp for the beginning of a span}

\item{finishTime}{a POSIXct timestamp for the end of a span}
}
\value{
the span, except for getContext which returns the span's parent context and baggage, which returns any baggage objects.
}
\description{
These define the core methods required by the specification for using spans.
}
\note{
Developers should implement the \code{otlog} method only for their spans - log is a generic method used by R for logarithms. \code{ot::log} is an alias for convenience only.
}
\examples{
s <- ot::startSpan(ot::getNoOpTracer())
ot::setTags(s, foo=1)
ot::baggage(s) <- list(ctx=1)
ot::getContext(s)
ot::otlog(s, foo=1)
ot::log(s, bar=2)
ot::finish(s)
ot::baggage(s)
}
