% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmTableErrors.R
\name{osrmTableErrors}
\alias{osrmTableErrors}
\title{Detect Errors in Distance Matrices}
\usage{
osrmTableErrors(mat)
}
\arguments{
\item{mat}{A distance matrix.}
}
\value{
A list of two vectors of identifier: originErrors and destinationErrors.
}
\description{
Detect errors in distance matrices.
}
\note{
An error is detected when at least half of distances are not found for an element.
}
\examples{
\dontrun{
# Load data
data("com")
# Travel time matrix
distcom <- osrmTable(com[1:50,], id = "comm_id", x =  "lon",y =  "lat")
# First 5 rows and columns
distcom[1:5,1:5]
# Get errors
osrmTableErrors(distcom)
}
}
\seealso{
\link{osrmTable}, \link{osrmTableOD}
}

