% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-osm-objects.R
\name{add_osm_objects}
\alias{add_osm_objects}
\title{add_osm_objects}
\usage{
add_osm_objects(map, obj, col = "gray40", border = NA, hcol, size, shape)
}
\arguments{
\item{map}{A \code{ggplot2} object to which the objects are to be added.}

\item{obj}{A spatial (\code{sp}) data frame of polygons, lines, or points,
typically as returned by \code{\link{extract_osm_objects}}.}

\item{col}{Colour of lines or points; fill colour of polygons.}

\item{border}{Border colour of polygons.}

\item{hcol}{(Multipolygons only) Vector of fill colours for holes}

\item{size}{Size argument passed to \code{ggplot2} (polygon, path, point)
functions: determines width of lines for (polygon, line), and sizes of
points.  Respective defaults are (0, 0.5, 0.5).}

\item{shape}{Shape of points or lines (the latter passed as \code{linetype});
see \code{\link[ggplot2]{shape}}.}
}
\value{
modified version of \code{map} to which objects have been added.
}
\description{
Adds layers of spatial objects (polygons, lines, or points generated by
\code{\link{extract_osm_objects}}) to a graphics object initialised with
\code{\link{osm_basemap}}.
}
\examples{
bbox <- get_bbox (c (-0.13, 51.5, -0.11, 51.52))
map <- osm_basemap (bbox = bbox, bg = "gray20")

\dontrun{
# The 'london' data used below were downloaded as:
dat_BNR <- extract_osm_objects (bbox = bbox, key = 'building',
                                value = '!residential')
dat_HP <- extract_osm_objects (bbox = bbox, key = 'highway',
                               value = 'primary')
dat_T <- extract_osm_objects (bbox = bbox, key = 'tree')
}
map <- add_osm_objects (map, obj = london$dat_BNR,
                        col = "gray40", border = "yellow")
map <- add_osm_objects (map, obj = london$dat_HP, col = "gray80",
                        size = 1, shape = 2)
map <- add_osm_objects (map, london$dat_T, col = "green",
                        size = 2, shape = 1)
print_osm_map (map)

# Polygons with different coloured borders
map <- osm_basemap (bbox = bbox, bg = "gray20")
map <- add_osm_objects (map, obj = london$dat_HP, col = "gray80")
map <- add_osm_objects (map, london$dat_T, col = "green")
map <- add_osm_objects (map, obj = london$dat_BNR, col = "gray40",
                        border = "yellow", size = 0.5)
print_osm_map (map)
}
\seealso{
\code{\link{osm_basemap}}, \code{\link{extract_osm_objects}}.
}
