/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util;

import fr.ird.osmose.Cell;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.grid.IGrid;

public class GridPoint {
    private float x;
    private float y;
    private float lon;
    private float lat;

    public boolean isInWater() {
        return !this.getCell().isLand();
    }

    public boolean isOnEdge() {
        return this.x > (float)GridPoint.getGrid().get_nx() - 2.0f || this.x < 1.0f || this.y > (float)GridPoint.getGrid().get_ny() - 2.0f || this.y < 1.0f;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getLon() {
        return this.lon;
    }

    public float getLat() {
        return this.lat;
    }

    public boolean isUnlocated() {
        return this.x < 0.0f || this.y < 0.0f;
    }

    public void setOffGrid() {
        this.y = -1.0f;
        this.x = -1.0f;
    }

    public Cell getCell() {
        return GridPoint.getGrid().getCell(Math.round(this.x), Math.round(this.y));
    }

    public void moveToCell(Cell cell) {
        this.x = cell.get_igrid();
        this.y = cell.get_jgrid();
    }

    public static IGrid getGrid() {
        return Osmose.getInstance().getGrid();
    }
}

