/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality.fishing;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.mortality.fishing.AbstractFishingMortality;
import fr.ird.osmose.util.timeseries.ByClassTimeSeries;

public class CatchesByDtByClassFishingMortality
extends AbstractFishingMortality {
    private double[][] catches;
    private float[] sizeClasses;
    private float[] ageClasses;
    private double[] fishableBiomass;

    public CatchesByDtByClassFishingMortality(int rank, Species species) {
        super(rank, species);
    }

    @Override
    public void init() {
        int iSpec = this.getIndexSpecies();
        if (!this.getConfiguration().isNull("mortality.fishing.catches.byDt.byAge.file.sp" + iSpec)) {
            ByClassTimeSeries timeSerieByAge = new ByClassTimeSeries(this.getRank());
            timeSerieByAge.read(this.getConfiguration().getFile("mortality.fishing.catches.byDt.byAge.file.sp" + iSpec));
            this.catches = timeSerieByAge.getValues();
            this.ageClasses = new float[timeSerieByAge.getNClass() - 1];
            for (int k = 0; k < this.ageClasses.length; ++k) {
                this.ageClasses[k] = Math.round(timeSerieByAge.getClass(k) * (float)this.getConfiguration().getNStepYear());
            }
        } else if (!this.getConfiguration().isNull("mortality.fishing.catches.byDt.bySize.file.sp" + iSpec)) {
            ByClassTimeSeries timeSerieBySize = new ByClassTimeSeries(this.getRank());
            timeSerieBySize.read(this.getConfiguration().getFile("mortality.fishing.catches.byDt.bySize.file.sp" + iSpec));
            this.catches = timeSerieBySize.getValues();
            this.sizeClasses = timeSerieBySize.getClasses();
        } else {
            this.getSimulation().error("Could not found parameters mortality.fishing.catches.byDt.byAge/bySize.file.sp" + iSpec, null);
        }
    }

    @Override
    public double getRate(School school) {
        throw new UnsupportedOperationException("No fishing mortality rates specified in this fishing scenario.");
    }

    @Override
    public double getCatches(School school) {
        int k = -1;
        if (null != this.sizeClasses) {
            k = this.indexOf(school.getLength(), this.sizeClasses);
        } else if (null != this.ageClasses) {
            k = this.indexOf(school.getAgeDt(), this.ageClasses);
        }
        if (k >= 0 && this.fishableBiomass[k] > 0.0) {
            return school.getInstantaneousBiomass() / this.fishableBiomass[k] * this.catches[this.getSimulation().getIndexTimeSimu()][k];
        }
        return 0.0;
    }

    private int indexOf(float value, float[] classes) {
        if (value < classes[0]) {
            return -1;
        }
        for (int k = 0; k < classes.length - 1; ++k) {
            if (!(classes[k] <= value) || !(value < classes[k + 1])) continue;
            return k;
        }
        return classes.length - 1;
    }

    @Override
    public void assessFishableBiomass() {
        for (int i = 0; i < this.fishableBiomass.length; ++i) {
            this.fishableBiomass[i] = 0.0;
        }
        int k = -1;
        for (School school : this.getSchoolSet().getSchools(this.getSpecies(), false)) {
            if (null != this.sizeClasses) {
                k = this.indexOf(school.getLength(), this.sizeClasses);
            } else if (null != this.ageClasses) {
                k = this.indexOf(school.getAgeDt(), this.ageClasses);
            }
            if (k < 0) continue;
            int n = k;
            this.fishableBiomass[n] = this.fishableBiomass[n] + school.getInstantaneousBiomass();
        }
    }
}

