/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality.fishing;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.mortality.FishingMortality;
import fr.ird.osmose.process.mortality.fishing.AbstractFishingMortality;
import fr.ird.osmose.util.timeseries.SingleTimeSeries;

public class BySeasonFishingMortality
extends AbstractFishingMortality {
    private double annualF;
    private double annualCatches;
    private double[] season;
    private int recruitmentAge;
    private float recruitmentSize;
    private final FishingMortality.Type type;
    private double fishableBiomass;

    public BySeasonFishingMortality(int rank, Species species, FishingMortality.Type type) {
        super(rank, species);
        this.type = type;
    }

    @Override
    public void init() {
        int nStepYear = this.getConfiguration().getNStepYear();
        int iSpec = this.getIndexSpecies();
        switch (this.type) {
            case RATE: {
                this.annualF = this.getConfiguration().getDouble("mortality.fishing.rate.sp" + iSpec);
                this.annualCatches = 0.0;
                break;
            }
            case CATCHES: {
                this.annualCatches = this.getConfiguration().getDouble("mortality.fishing.catches.sp" + iSpec);
                this.annualF = 0.0;
            }
        }
        if (!this.getConfiguration().isNull("mortality.fishing.recruitment.age.sp" + iSpec)) {
            float age = this.getConfiguration().getFloat("mortality.fishing.recruitment.age.sp" + iSpec);
            this.recruitmentAge = Math.round(age * (float)nStepYear);
            this.recruitmentSize = 0.0f;
        } else if (!this.getConfiguration().isNull("mortality.fishing.recruitment.size.sp" + iSpec)) {
            this.recruitmentSize = this.getConfiguration().getFloat("mortality.fishing.recruitment.size.sp" + iSpec);
            this.recruitmentAge = 0;
        } else {
            this.recruitmentAge = 0;
            this.recruitmentSize = 0.0f;
            this.getSimulation().warning("Could not find any fishing recruitment threshold (neither age nor size) for species {0}. Osmose assumes every school can be catched.", this.getSpecies().getName());
        }
        SingleTimeSeries sts = new SingleTimeSeries(this.getRank());
        String filename = this.getConfiguration().getFile("mortality.fishing.season.distrib.file.sp" + iSpec);
        sts.read(filename);
        this.season = sts.getValues();
    }

    @Override
    public double getRate(School school) {
        return school.getAgeDt() >= this.recruitmentAge && school.getLength() >= this.recruitmentSize ? this.annualF * this.season[this.getSimulation().getIndexTimeYear()] : 0.0;
    }

    @Override
    public void assessFishableBiomass() {
        this.fishableBiomass = 0.0;
        for (School school : this.getSchoolSet().getSchools(this.getSpecies(), false)) {
            if (school.isUnlocated() || !this.isFishable(school)) continue;
            this.fishableBiomass += school.getInstantaneousBiomass();
        }
    }

    private boolean isFishable(School school) {
        return school.getAgeDt() >= this.recruitmentAge && school.getLength() >= this.recruitmentSize;
    }

    @Override
    public double getCatches(School school) {
        if (this.isFishable(school) && this.fishableBiomass > 0.0) {
            return (double)((float)(school.getInstantaneousBiomass() / this.fishableBiomass)) * this.annualCatches * this.season[this.getSimulation().getIndexTimeYear()];
        }
        return 0.0;
    }
}

