/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality;

import fr.ird.osmose.School;
import fr.ird.osmose.process.mortality.AbstractMortality;

public class OutMortality
extends AbstractMortality {
    private double[] Zout;

    public OutMortality(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        int nSpecies = this.getConfiguration().getNSpecies();
        int nStepYear = this.getConfiguration().getNStepYear();
        this.Zout = new double[nSpecies];
        for (int i = 0; i < nSpecies; ++i) {
            if (this.getConfiguration().isNull("mortality.out.rate.sp" + i)) continue;
            this.Zout[i] = this.getConfiguration().getDouble("mortality.out.rate.sp" + i) / (double)nStepYear;
        }
    }

    @Override
    public double getRate(School school) {
        return this.Zout[school.getSpeciesIndex()];
    }
}

