/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.populator;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.populator.AbstractPopulator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import ucar.nc2.NetcdfFile;

public class NetcdfPopulator
extends AbstractPopulator {
    private NetcdfFile nc;
    private final String key;

    public NetcdfPopulator(int rank, String key) {
        super(rank);
        this.key = key;
    }

    @Override
    public void init() {
        String plainFilename = this.getConfiguration().getFile(this.key);
        String rankedFilename = plainFilename + "." + this.getRank();
        boolean plainFile = false;
        boolean rankedFile = false;
        if (new File(plainFilename).exists()) {
            plainFile = true;
        }
        if (new File(rankedFilename).exists()) {
            rankedFile = true;
        }
        if (!plainFile && !rankedFile) {
            this.error("Could not find any NetCDF initialization file (check parameter " + this.key + ").", new FileNotFoundException("Neither file " + plainFilename + " nor " + rankedFilename + " exist."));
        } else if (plainFile && rankedFile) {
            this.warning("Found two suitable NetCDF initialization files: " + plainFilename + " and " + rankedFilename + ". Osmose will use the latest " + rankedFilename);
        }
        String ncfile = rankedFile ? rankedFilename : plainFilename;
        try {
            this.nc = NetcdfFile.open(ncfile);
        }
        catch (IOException ex) {
            this.error("Failed to open restart file " + ncfile, ex);
        }
    }

    @Override
    public void populate() {
        int nSchool = this.nc.findDimension("nschool").getLength();
        try {
            int[] ispecies = (int[])this.nc.findVariable("species").read().copyTo1DJavaArray();
            float[] x = (float[])this.nc.findVariable("x").read().copyTo1DJavaArray();
            float[] y = (float[])this.nc.findVariable("y").read().copyTo1DJavaArray();
            double[] abundance = (double[])this.nc.findVariable("abundance").read().copyTo1DJavaArray();
            float[] length = (float[])this.nc.findVariable("length").read().copyTo1DJavaArray();
            float[] weight = (float[])this.nc.findVariable("weight").read().copyTo1DJavaArray();
            float[] age = (float[])this.nc.findVariable("age").read().copyTo1DJavaArray();
            float[] trophiclevel = (float[])this.nc.findVariable("trophiclevel").read().copyTo1DJavaArray();
            for (int s = 0; s < nSchool; ++s) {
                Species species = this.getSimulation().getSpecies(ispecies[s]);
                School school = new School(species, x[s], y[s], abundance[s], length[s], weight[s], Math.round(age[s] * (float)this.getConfiguration().getNStepYear()), trophiclevel[s]);
                this.getSchoolSet().add(school);
            }
            this.nc.close();
        }
        catch (IOException ex) {
            this.error("Error reading restart file " + this.nc.getLocation(), ex);
        }
    }
}

